package com.anplus.hr.domain.vo;

import cn.idev.excel.annotation.ExcelProperty;
import com.anplus.hr.constant.HrConstant;
import com.anplus.hr.domain.EmployeeInfo;
import io.github.linpeilie.annotations.AutoMapper;
import io.github.linpeilie.annotations.AutoMappers;
import lombok.Getter;
import lombok.Setter;
import top.binfast.common.excel.annotion.ExcelDictFormat;
import top.binfast.common.excel.converters.ExcelDictConvert;

import java.io.Serial;
import java.time.LocalDate;

/**
 * @author 刘斌
 * @date 2025/11/13 20:47
 */
@Getter
@AutoMappers({
        @AutoMapper(target = EmployeeInfo.class, reverseConvertGenerate = false),
})
public class EmployeeInfoResignImportVo extends EmployeeInfoImportVo {
    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 离职类型
     */
    @ExcelProperty(value = "离职类型", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_RESIGNATION_TYPE)
    private String resignationType;


    /**
     * 离职类别
     */
    @ExcelProperty(value = "离职类别", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_RESIGNATION_CATEGORY)
    private String resignationCategory;

    /**
     * 离职时间
     */
    @Setter
    @ExcelProperty(value = "离职时间")
    private LocalDate resignationDate;

    /**
     * 离职原因
     */
    @ExcelProperty(value = "离职原因")
    private String resignationReason;

    /**
     * 最后结薪日
     */
    @Setter
    @ExcelProperty(value = "最后结薪日")
    private LocalDate finalPayDate;

    public void setResignationType(String resignationType) {
        this.resignationType = resignationType == null ? null : resignationType.trim();
    }

    public void setResignationReason(String resignationReason) {
        this.resignationReason = resignationReason == null ? null : resignationReason.trim();
    }

    public void setResignationCategory(String resignationCategory) {
        this.resignationCategory = resignationCategory == null ? null : resignationCategory.trim();
    }

}
