package com.anplus.hr.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import com.alibaba.cola.dto.MultiResponse;
import com.anplus.hr.domain.params.EmployeeChangeAnalysisListParam;
import com.anplus.hr.domain.vo.EmployeeChangeAnalysisVo;
import com.anplus.hr.service.EmployeeChangeAnalysisServ;
import jakarta.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import top.binfast.common.core.constant.BusinessType;
import top.binfast.common.excel.annotion.ExcelExport;
import top.binfast.common.log.annotation.PinSysLog;

import java.util.List;

/**
 * 人员变化分析
 *
 * @author LiuBin
 * @date 2025-11-23
 */
@Validated
@RestController
@RequestMapping("/employee/changeAnalysis")
public class EmployeeChangeAnalysisCtrl {

    @Resource
    private EmployeeChangeAnalysisServ employeeChangeAnalysisServ;

    /**
     * 查询人员变化分析列表
     */
    @SaCheckPermission("employee:changeAnalysis:list")
    @GetMapping("/page")
    public MultiResponse<EmployeeChangeAnalysisVo> pageList(EmployeeChangeAnalysisListParam param) {
        return MultiResponse.of(employeeChangeAnalysisServ.queryList(param));
    }

    /**
     * 导出人员变化分析列表
     */
    @ExcelExport(template = "人员变化分析模板.xlsx", fill = true)
    @SaCheckPermission("employee:changeAnalysis:export")
    @PinSysLog(value = "人员变化分析", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public List<EmployeeChangeAnalysisVo> export(EmployeeChangeAnalysisListParam param) {
        return employeeChangeAnalysisServ.queryList(param);
    }

//    /**
//     * 获取人员变化分析详细信息
//     *
//     * @param id 主键
//     */
//    @SaCheckPermission("hr:changeAnalysis:query")
//    @GetMapping("/{id}")
//    public SingleResponse<EmployeeChangeAnalysisVo> getDetail(@PathVariable @Min(1)
//                                                    Long id) {
//        return SingleResponse.of(employeeChangeAnalysisServ.queryById(id));
//    }
//
//    /**
//     * 新增人员变化分析
//     */
//    @SaCheckPermission("hr:changeAnalysis:add")
//    @PinSysLog(value = "人员变化分析", businessType = BusinessType.INSERT)
//    @PostMapping()
//    public Response add(@Validated(AddGroup.class) @RequestBody EmployeeChangeAnalysisParam param) {
//        return ResponseUtils.ofResult(employeeChangeAnalysisServ.insertByParam(param));
//    }
//
//    /**
//     * 修改人员变化分析
//     */
//    @SaCheckPermission("hr:changeAnalysis:edit")
//    @PinSysLog(value = "人员变化分析", businessType = BusinessType.UPDATE)
//    @PutMapping()
//    public Response edit(@Validated(EditGroup.class) @RequestBody EmployeeChangeAnalysisParam param) {
//        return ResponseUtils.ofResult(employeeChangeAnalysisServ.updateByParam(param));
//    }
//
//    /**
//     * 删除人员变化分析
//     *
//     * @param ids 主键串
//     */
//    @SaCheckPermission("hr:changeAnalysis:remove")
//    @PinSysLog(value = "人员变化分析", businessType = BusinessType.DELETE)
//    @DeleteMapping("/{ids}")
//    public Response remove(@NotEmpty(message = "主键不能为空")
//                           @PathVariable Long[] ids) {
//        return ResponseUtils.ofResult(employeeChangeAnalysisServ.delByIds(List.of(ids)));
//    }
}