package com.anplus.hr.domain.vo;

import cn.idev.excel.annotation.ExcelIgnore;
import cn.idev.excel.annotation.ExcelIgnoreUnannotated;
import cn.idev.excel.annotation.ExcelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;



/**
 * 人员变化分析视图对象 employee_change_analysis
 *
 * @author LiuBin
 * @date 2025-11-23
 */
@Data
@ExcelIgnoreUnannotated
//@AutoMapper(target = EmployeeChangeAnalysis.class)
public class EmployeeChangeAnalysisVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 板块
     */
    @ExcelProperty(value = "公司")
    private String plate;

    /**
     * 板块ID
     */
    @ExcelIgnore
    private String plateId;

    /**
     * 期初人数
     */
    @ExcelProperty(value = "期初人数")
    private Integer beginningCount;

    /**
     * 入职人数
     */
    @ExcelProperty(value = "入职人数")
    private Integer entryCount;

    /**
     * 转正人数
     */
    @ExcelProperty(value = "转正人数")
    private Integer regularCount;

    /**
     * 转入
     */
    @ExcelProperty(value = {"异动人数", "调入"})
    private Integer transferIn;

    /**
     * 转出
     */
    @ExcelProperty(value = {"异动人数", "调出"})
    private Integer transferOut;

    /**
     * 试用期内
     */
    @ExcelProperty(value = {"月离职人数", "主动离职", "试用期内（6个月）"})
    private Integer probationPeriod;

    /**
     * 入职3年内
     */
    @ExcelProperty(value = {"月离职人数", "主动离职", "入职3年内"})
    private Integer within3Years;

    /**
     * 入职3年以上
     */
    @ExcelProperty(value = {"月离职人数", "主动离职", "入职3年以上"})
    private Integer over3Years;

    /**
     * 被动离职
     */
    @ExcelProperty(value = {"月离职人数", "被动离职"})
    private Integer passiveResignation;

    /**
     * 总离职
     */
    @ExcelProperty(value = {"月离职人数", "总离职"})
    private Integer totalResignation;

    /**
     * 期末人数
     */
    @ExcelProperty(value = "期末人数")
    private Integer endingCount;

    /**
     * 试用期内离职率
     */
    @ExcelProperty(value = {"月离职率", "主动离职率", "试用期内（6个月）"})
    private String probationResignationRate;

    /**
     * 入职3年内离职率
     */
    @ExcelProperty(value = {"月离职率", "主动离职率", "入职3年内离职率"})
    private String within3YearsResignationRate;

    /**
     * 入职3年以上离职率
     */
    @ExcelProperty(value = {"月离职率", "主动离职率", "入职3年以上离职率"})
    private String over3YearsResignationRate;

    /**
     * 被动离职率
     */
    @ExcelProperty(value = {"月离职率", "被动离职率"})
    private String passiveResignationRate;

    /**
     * 总离职率
     */
    @ExcelProperty(value = {"月离职率", "总离职率"})
    private String totalResignationRate;


    public EmployeeChangeAnalysisVo(String plate) {
        this.plate = plate;
        this.beginningCount = 0;
        this.entryCount = 0;
        this.regularCount = 0;
        this.transferIn = 0;
        this.transferOut = 0;
        this.probationPeriod = 0;
        this.within3Years = 0;
        this.over3Years = 0;
        this.passiveResignation = 0;
        this.totalResignation = 0;
        this.endingCount = 0;
    }
}
