package com.anplus.hr.domain.params;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.time.LocalDate;

/**
 * @author 刘斌
 * @date 2025/10/31 15:47
 */
@Data
public class EmployeeEntryApplyParam {

    private Long id;

    /**
     * 员工id
     */
    @NotBlank(message = "员工不能为空")
    private Long employeeId;

    /**
     * 入职时间
     */
    @NotNull(message = "入职时间不能为空")
    private LocalDate entryDate;

    private String remark;
}
