package com.anplus.hr.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import top.binfast.common.mybatis.bean.model.TenantModel;

import java.io.Serial;
import java.time.LocalDate;

/**
 * 员工信息对象 employee_info
 *
 * @author LiuBin
 * @date 2025-11-13
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = true)
@TableName("employee_info")
public class EmployeeInfo extends TenantModel {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 板块
     */
    private String plate;

    /**
     * 一级部门
     */
    private String firstLevelDepartment;

    /**
     * 二级部门
     */
    private String secondLevelDepartment;

    /**
     * 三级部门
     */
    private String thirdLevelDepartment;

    /**
     * 部门ID
     */
    private Long deptId;

    /**
     * 工号
     */
    private String employeeNo;

    /**
     * 职级
     */
    private Integer jobLevel;

    /**
     * 岗位类型
     */
    private String positionType;

    /**
     * 序列
     */
    private String sequence;

    /**
     * 主岗位
     */
    private String position;

    /**
     * 姓名
     */
    private String name;

    /**
     * 性别
     */
    private String gender;

    /**
     * 头像OSS_ID
     */
    private Long ossId;

    /**
     * 身份证号码
     */
    private String idCardNumber;

    /**
     * 出生日期
     */
    private LocalDate birthDate;

    /**
     * 年龄
     */
    private Integer age;

    /**
     * 年龄段
     */
    private String ageGroup;

    /**
     * 兼岗板块
     */
    private String concurrentPlate;

    /**
     * 兼岗一级部门
     */
    private String concurrentFirstDept;

    /**
     * 兼岗二级部门
     */
    private String concurrentSecondDept;

    /**
     * 兼岗三级部门
     */
    private String concurrentThirdDept;

    /**
     * 兼岗部门ID
     */
    private Long concurrentDeptId;

    /**
     * 兼岗岗位
     */
    private String concurrentPosition;

    /**
     * 兼岗岗位类型
     */
    private String concurrentPositionType;

    /**
     * 籍贯
     */
    private String nativePlace;

    /**
     * 民族
     */
    private String ethnicity;

    /**
     * 婚姻状况
     */
    private String maritalStatus;

    /**
     * 政治面貌
     */
    private String politicalStatus;

    /**
     * 手机号码
     */
    private String phoneNumber;

    /**
     * 紧急联系人
     */
    private String emergencyContact;

    /**
     * 紧急联系人电话
     */
    private String emergencyContactPhone;

    /**
     * 家庭地址
     */
    private String homeAddress;

    /**
     * 户口所在地
     */
    private String householdRegistrationAddress;

    /**
     * 参加工作时间
     */
    private LocalDate workStartDate;

    /**
     * 入职时间
     */
    private LocalDate entryDate;

    /**
     * 工龄
     */
    private String yearsOfService;

    /**
     * 工龄总月数
     */
    private Integer yearsOfServiceMonths;

    /**
     * 工龄段
     */
    private String yearsOfServiceSegment;

    /**
     * 全日制学历
     */
    private String fulltimeEducation;

    /**
     * 全日制毕业院校
     */
    private String fulltimeSchool;

    /**
     * 全日制专业
     */
    private String fulltimeMajor;

    /**
     * 全日制毕业日期
     */
    private LocalDate fulltimeGraduationDate;

    /**
     * 全日制学位
     */
    private String fulltimeDegree;

    /**
     * 非全日制学历
     */
    private String nonFulltimeEducation;

    /**
     * 非全日制毕业院校
     */
    private String nonFulltimeSchool;

    /**
     * 非全日制专业
     */
    private String nonFulltimeMajor;

    /**
     * 非全日制毕业日期
     */
    private LocalDate nonFulltimeGraduationDate;

    /**
     * 非全日制学位
     */
    private String nonFulltimeDegree;

    /**
     * 学历分类
     */
    private String educationCategory;

    /**
     * 员工类型
     */
    private String employeeType;

    /**
     * 职称情况
     */
    private String professionalTitle;

    /**
     * 证书情况
     */
    private String certificateStatus;

    /**
     * 外部个人履历
     */
    private String externalResume;

    /**
     * 内部个人履历
     */
    private String internalResume;

    /**
     * 用工形式
     */
    private String employmentForm;

    /**
     * 合同形式
     */
    private String contractForm;

    /**
     * 劳动合同期限
     */
    private String contractTerm;

    /**
     * 劳动合同开始时间
     */
    private LocalDate contractStartDate;

    /**
     * 劳动合同截止时间
     */
    private LocalDate contractEndDate;

    /**
     * 合同到期提醒
     */
    private LocalDate contractExpirationReminder;

    /**
     * 劳动合同签订情况
     */
    private String contractSigningStatus;

    /**
     * 合同主体
     */
    private String contractEntity;

    /**
     * 社保主体
     */
    private String socialSecurityEntity;

    /**
     * 是否缴纳社保
     */
    private String hasSocialSecurityPaid;

    /**
     * 公积金主体
     */
    private String providentFundEntity;

    /**
     * 是否缴纳公积金
     */
    private String hasProvidentFundPaid;

    /**
     * 是否缴纳雇主险
     */
    private String hasEmployerInsurancePaid;

    /**
     * 试用期（月数）
     */
    private Integer probationPeriod;

    /**
     * 转正时间
     */
    private LocalDate regularizationDate;

    /**
     * 预计转正时间
     */
    private LocalDate expectedRegularDate;

    /**
     * 奖励情况
     */
    private String rewardStatus;

    /**
     * 处罚情况
     */
    private String punishmentStatus;

    /**
     * 备注
     */
    private String remarks;

    /**
     * 办公电话
     */
    private String officePhone;

    /**
     * 短线
     */
    private String shortLine;

    /**
     * 银行卡号
     */
    private String bankCardNumber;

    /**
     * 开户行
     */
    private String bankName;

    /**
     * 公司内是否有亲属关系
     */
    private String hasRelativeInCompany;

    /**
     * 亲属姓名
     */
    private String relativeName;

    /**
     * 介绍人
     */
    private String introducer;

    /**
     * 介绍人关系
     */
    private String introducerRelation;

    /**
     * 工资发放地
     */
    private String salaryLocation;

    /**
     * 编制所在地
     */
    private String staffingLocation;

    /**
     * 成本费用所属(写部门)
     */
    private String costOfDept;

    /**
     * 成本费用细分
     */
    private String costType;

    /**
     * 绩效比例
     */
    private String performanceRatio;

    /**
     * 工装(某年某月发放价值多少钱的工装)
     */
    private String workwearDetail;

    /**
     * 内部购房优惠(是，否)
     */
    private String internalPurchaseDiscounts;

    /**
     * 安泰业主(是，否)
     */
    private String antaiHomeowners;

    /**
     * 安泰小区信息
     */
    private String antaiCommunityInfo;

    /**
     * 离职类型
     */
    private String resignationType;

    /**
     * 离职类别
     */
    private String resignationCategory;

    /**
     * 离职时间
     */
    private LocalDate resignationDate;

    /**
     * 离职原因
     */
    private String resignationReason;

    /**
     * 最后结薪日
     */
    private LocalDate finalPayDate;

    /**
     * 员工状态
     */
    private Integer status;

    /**
     * 离职申请状态
     */
    private Integer resignationApplyStatus;

    /**
     * 入职审批状态
     */
    private Integer entryApplyStatus;

    /**
     * 调配申请状态
     */
    private Integer transferApplyStatus;

    /**
     * 转正申请状态
     */
    private Integer regularApplyStatus;

    /**
     * 续签合同申请状态
     */
    private Integer renewalApplyStatus;

    /**
     * 照片
     */
    @TableField(exist = false)
    private String photo;

}
