package com.anplus.hr.service;

import com.alibaba.cola.dto.PageResponse;
import com.baomidou.mybatisplus.extension.service.IService;
import com.anplus.hr.domain.EmployeeFlow;
import com.anplus.hr.domain.params.EmployeeFlowListParam;
import com.anplus.hr.domain.params.EmployeeFlowParam;
import com.anplus.hr.domain.vo.EmployeeFlowVo;

import java.util.List;

/**
 * 人事审批对象Service接口
 *
 * @author LiuBin
 * @date 2025-10-31
 */
public interface EmployeeFlowServ extends IService<EmployeeFlow> {


    /**
     * 分页查询人事审批对象列表
     *
     * @param param        查询条件
     * @return 人事审批对象分页列表
     */
    PageResponse<EmployeeFlowVo> queryPageList(EmployeeFlowListParam param);

    /**
     * 查询符合条件的人事审批对象列表
     *
     * @param param 查询条件
     * @return 人事审批对象列表
     */
    List<EmployeeFlowVo> queryList(EmployeeFlowListParam param);

    /**
     * 查询人事审批对象
     *
     * @param id 主键
     * @return 人事审批对象
     */
     EmployeeFlowVo queryById(Long id);

    /**
     * 新增人事审批对象
     *
     * @param param 人事审批对象
     * @return 是否新增成功
     */
    EmployeeFlowVo insertByParam(EmployeeFlowParam param);

    /**
     * 修改人事审批对象
     *
     * @param param 人事审批对象
     * @return 是否修改成功
     */
    EmployeeFlowVo updateByParam(EmployeeFlowParam param);

    /**
     * 新增或修改人事审批对象
     *
     * @param param 人事审批对象
     * @return 是否新增或修改成功
     */
    EmployeeFlowVo insertOrUpdateByParam(EmployeeFlowParam param);

    /**
     * 提交请假并发起流程
     */
    EmployeeFlowVo submitAndFlowStart(EmployeeFlowParam param);

    /**
     * 校验并批量删除人事审批对象信息
     *
     * @param ids     待删除的主键集合
     * @return 是否删除成功
     */
    Boolean delByIds(List<Long> ids);

}
