package com.anplus.hr.domain.vo;

import cn.idev.excel.annotation.ExcelIgnore;
import cn.idev.excel.annotation.ExcelIgnoreUnannotated;
import cn.idev.excel.annotation.ExcelProperty;
import com.anplus.hr.constant.HrConstant;
import com.anplus.hr.domain.EmployeeInfo;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.core.trans.anno.Trans;
import org.dromara.core.trans.constant.TransType;
import org.dromara.core.trans.vo.TransPojo;
import top.binfast.common.excel.annotion.ExcelDictFormat;
import top.binfast.common.excel.converters.ExcelDictConvert;
import top.binfast.common.excel.converters.ExcelUrlImageConverter;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDate;



/**
 * 员工信息视图对象 employee_info
 *
 * @author LiuBin
 * @date 2025-11-13
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = EmployeeInfo.class)
public class EmployeeInfoVo implements TransPojo, Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 序号
     */
    private Long id;

    /**
     * 板块
     */
    @ExcelProperty(value = "板块")
    private String plate;

    /**
     * 一级部门
     */
    @ExcelProperty(value = "一级部门")
    private String firstLevelDepartment;

    /**
     * 二级部门
     */
    @ExcelProperty(value = "二级部门")
    private String secondLevelDepartment;

    /**
     * 三级部门
     */
    @ExcelProperty(value = "三级部门")
    private String thirdLevelDepartment;

    /**
     * 部门ID
     */
    @ExcelProperty(value = "部门ID")
    private Long deptId;

    /**
     * 工号
     */
    @ExcelProperty(value = "工号")
    private String employeeNo;

    /**
     * 职级
     */
    @ExcelProperty(value = "职级")
//    @ExcelDictFormat(dictType = "HR_JOB_LEVEL")
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_JOB_LEVEL)
    private Integer jobLevel;

    /**
     * 岗位类型
     */
    @ExcelProperty(value = "岗位类型", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_POSITION_TYPE)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_POSITION_TYPE)
    private String positionType;

    /**
     * 序列
     */
    @ExcelProperty(value = "序列", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_SEQUENCE)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_SEQUENCE)
    private String sequence;

    /**
     * 主岗位
     */
    @ExcelProperty(value = "主岗位")
    private String position;

    /**
     * 姓名
     */
    @ExcelProperty(value = "姓名")
    private String name;

    /**
     * 性别
     */
    @ExcelProperty(value = "性别", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_USER_SEX)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_USER_SEX)
    private String gender;

    /**
     * 身份证号码
     */
    @ExcelProperty(value = "身份证号码")
    private String idCardNumber;

    /**
     * 头像OSS_ID
     */
    @ExcelIgnore
    private Long ossId;

    /**
     * 照片
     */
    @ExcelProperty(value = "照片", converter = ExcelUrlImageConverter.class)
    private String photo;

    /**
     * 出生日期
     */
    @ExcelProperty(value = "出生日期")
    private LocalDate birthDate;

    /**
     * 年龄
     */
    @ExcelProperty(value = "年龄")
    private Integer age;

    /**
     * 年龄段
     */
    @ExcelProperty(value = "年龄段", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_AGE_GROUP)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_AGE_GROUP)
    private String ageGroup;

    /**
     * 兼职板块
     */
    @ExcelProperty(value = "兼职板块")
    private String partTimePlate;

    /**
     * 兼职一级部门
     */
    @ExcelProperty(value = "兼职一级部门")
    private String partTimeFirstDept;

    /**
     * 兼职二级部门
     */
    @ExcelProperty(value = "兼职二级部门")
    private String partTimeSecondDept;

    /**
     * 兼职三级部门
     */
    @ExcelProperty(value = "兼职三级部门")
    private String partTimeThirdDept;

    /**
     * 兼职岗位
     */
    @ExcelProperty(value = "兼职岗位")
    private String partTimePosition;

    /**
     * 籍贯
     */
    @ExcelProperty(value = "籍贯")
    private String nativePlace;

    /**
     * 民族
     */
    @ExcelProperty(value = "民族")
    private String ethnicity;

    /**
     * 婚姻状况
     */
    @ExcelProperty(value = "婚姻状况", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_MARITAL_STATUS)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_MARITAL_STATUS)
    private String maritalStatus;

    /**
     * 政治面貌
     */
    @ExcelProperty(value = "政治面貌", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_POLITICAL_STATUS)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_POLITICAL_STATUS)
    private String politicalStatus;

    /**
     * 手机号码
     */
    @ExcelProperty(value = "手机号码")
    private String phoneNumber;

    /**
     * 紧急联系人
     */
    @ExcelProperty(value = "紧急联系人")
    private String emergencyContact;

    /**
     * 紧急联系人电话
     */
    @ExcelProperty(value = "紧急联系人电话")
    private String emergencyContactPhone;

    /**
     * 家庭地址
     */
    @ExcelProperty(value = "家庭地址")
    private String homeAddress;

    /**
     * 户口所在地
     */
    @ExcelProperty(value = "户口所在地")
    private String householdRegistrationAddress;

    /**
     * 参加工作时间
     */
    @ExcelProperty(value = "参加工作时间")
    private LocalDate workStartDate;

    /**
     * 入职时间
     */
    @ExcelProperty(value = "入职时间")
    private LocalDate entryDate;

    /**
     * 工龄
     */
    @ExcelProperty(value = "工龄")
    private String yearsOfService;

    /**
     * 工龄段
     */
    @ExcelProperty(value = "工龄段", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_YEARS_SERVICE_SEGMENT)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_YEARS_SERVICE_SEGMENT)
    private String yearsOfServiceSegment;

    /**
     * 全日制学历
     */
    @ExcelProperty(value = "全日制学历")
    private String fulltimeEducation;

    /**
     * 全日制毕业院校
     */
    @ExcelProperty(value = "全日制毕业院校")
    private String fulltimeSchool;

    /**
     * 全日制专业
     */
    @ExcelProperty(value = "全日制专业")
    private String fulltimeMajor;

    /**
     * 全日制毕业日期
     */
    @ExcelProperty(value = "全日制毕业日期")
    private LocalDate fulltimeGraduationDate;

    /**
     * 全日制学位
     */
    @ExcelProperty(value = "全日制学位")
    private String fulltimeDegree;

    /**
     * 非全日制学历
     */
    @ExcelProperty(value = "非全日制学历")
    private String nonFulltimeEducation;

    /**
     * 非全日制毕业院校
     */
    @ExcelProperty(value = "非全日制毕业院校")
    private String nonFulltimeSchool;

    /**
     * 非全日制专业
     */
    @ExcelProperty(value = "非全日制专业")
    private String nonFulltimeMajor;

    /**
     * 非全日制毕业日期
     */
    @ExcelProperty(value = "非全日制毕业日期")
    private LocalDate nonFulltimeGraduationDate;

    /**
     * 非全日制学位
     */
    @ExcelProperty(value = "非全日制学位")
    private String nonFulltimeDegree;

    /**
     * 学历分类
     */
    @ExcelProperty(value = "学历分类", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_EDUCATION_CATEGORY)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_EDUCATION_CATEGORY)
    private String educationCategory;

    /**
     * 员工类型
     */
    @ExcelProperty(value = "员工类型", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_EMPLOYEE_TYPE)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_EMPLOYEE_TYPE)
    private String employeeType;

    /**
     * 职称情况
     */
    @ExcelProperty(value = "职称情况")
    private String professionalTitle;

    /**
     * 证书情况
     */
    @ExcelProperty(value = "证书情况")
    private String certificateStatus;

    /**
     * 外部个人履历
     */
    @ExcelProperty(value = "外部个人履历")
    private String externalResume;

    /**
     * 内部个人履历
     */
    @ExcelProperty(value = "内部个人履历")
    private String internalResume;

    /**
     * 用工形式
     */
    @ExcelProperty(value = "用工形式", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_EMPLOYMENT_FORM)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_EMPLOYMENT_FORM)
    private String employmentForm;

    /**
     * 合同形式
     */
    @ExcelProperty(value = "合同形式", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_CONTRACT_FORM)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_CONTRACT_FORM)
    private String contractForm;

    /**
     * 劳动合同期限
     */
    @ExcelProperty(value = "劳动合同期限")
    private String contractTerm;

    /**
     * 劳动合同开始时间
     */
    @ExcelProperty(value = "劳动合同开始时间")
    private LocalDate contractStartDate;

    /**
     * 劳动合同截止时间
     */
    @ExcelProperty(value = "劳动合同截止时间")
    private LocalDate contractEndDate;

    /**
     * 合同到期提醒
     */
    @ExcelProperty(value = "合同到期提醒")
    private LocalDate contractExpirationReminder;

    /**
     * 劳动合同签订情况
     */
    @ExcelProperty(value = "劳动合同签订情况")
    private String contractSigningStatus;

    /**
     * 合同主体
     */
    @ExcelProperty(value = "合同主体")
    private String contractEntity;

    /**
     * 社保主体
     */
    @ExcelProperty(value = "社保主体")
    private String socialSecurityEntity;

    /**
     * 是否缴纳社保
     */
    @ExcelProperty(value = "是否缴纳社保", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.SYS_YES_NO)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.SYS_YES_NO)
    private String hasSocialSecurityPaid;

    /**
     * 公积金主体
     */
    @ExcelProperty(value = "公积金主体")
    private String providentFundEntity;

    /**
     * 是否缴纳公积金
     */
    @ExcelProperty(value = "是否缴纳公积金", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.SYS_YES_NO)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.SYS_YES_NO)
    private String hasProvidentFundPaid;

    /**
     * 试用期（月数）
     */
    @ExcelProperty(value = "试用期")
//    @ExcelDictFormat(readConverterExp = "月=数")
    private Integer probationPeriod;

    /**
     * 转正时间
     */
    @ExcelProperty(value = "转正时间")
    private LocalDate regularizationDate;

    /**
     * 奖励情况
     */
    @ExcelProperty(value = "奖励情况")
    private String rewardStatus;

    /**
     * 处罚情况
     */
    @ExcelProperty(value = "处罚情况")
    private String punishmentStatus;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remarks;

    /**
     * 办公电话
     */
    @ExcelProperty(value = "办公电话")
    private String officePhone;

    /**
     * 短线
     */
    @ExcelProperty(value = "短线")
    private String shortLine;

    /**
     * 银行卡号
     */
    @ExcelProperty(value = "银行卡号")
    private String bankCardNumber;

    /**
     * 开户行
     */
    @ExcelProperty(value = "开户行")
    private String bankName;

    /**
     * 公司内是否有亲属关系
     */
    @ExcelProperty(value = "公司内是否有亲属关系", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.SYS_YES_NO)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.SYS_YES_NO)
    private String hasRelativeInCompany;

    /**
     * 亲属姓名
     */
    @ExcelProperty(value = "亲属姓名")
    private String relativeName;

    /**
     * 介绍人
     */
    @ExcelProperty(value = "介绍人")
    private String introducer;

    /**
     * 工资发放地
     */
    @ExcelProperty(value = "工资发放地")
    private String salaryLocation;

    /**
     * 绩效比例
     */
    @ExcelProperty(value = "绩效比例")
    private String performanceRatio;

    /**
     * 员工状态
     */
    private Integer status;


    /**
     * 入职审批状态
     */
//    @ExcelProperty(value = "入职审批状态")
    private Integer entryApplyStatus;

    /**
     * 调配申请状态
     */
//    @ExcelProperty(value = "调配申请状态")
    private Integer transferApplyStatus;


}
