package com.anplus.hr.domain.vo;

import cn.idev.excel.annotation.ExcelIgnoreUnannotated;
import cn.idev.excel.annotation.ExcelProperty;
import com.anplus.hr.constant.HrConstant;
import com.anplus.hr.domain.EmployeeInfo;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.core.trans.anno.Trans;
import org.dromara.core.trans.constant.TransType;
import top.binfast.common.excel.annotion.ExcelDictFormat;
import top.binfast.common.excel.converters.ExcelDictConvert;

import java.time.LocalDate;

/**
 * @author 刘斌
 * @date 2025/11/13 20:44
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = EmployeeInfo.class)
public class EmployeeInfoResignVo extends EmployeeInfoVo {

    /**
     * 离职类型
     */
    @ExcelProperty(value = "离职类型", converter = ExcelDictConvert.class, index = 77)
    @ExcelDictFormat(dictType = HrConstant.HR_RESIGNATION_TYPE)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.HR_RESIGNATION_TYPE)
    private String resignationType;

    /**
     * 离职时间
     */
    @ExcelProperty(value = "离职时间", index = 78)
    private LocalDate resignationDate;

    /**
     * 离职原因
     */
    @ExcelProperty(value = "离职原因", index = 79)
    private String resignationReason;

    /**
     * 最后结薪日
     */
    @ExcelProperty(value = "最后结薪日", index = 80)
    private LocalDate finalPayDate;

    /**
     * 离职申请状态
     */
//    @ExcelProperty(value = "离职申请状态")
    private Integer resignationApplyStatus;

}
