package com.anplus.hr.domain.vo;

import cn.idev.excel.annotation.ExcelIgnoreUnannotated;
import cn.idev.excel.annotation.ExcelProperty;
import com.anplus.hr.domain.EmployeeFlow;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.List;


/**
 * 人事审批对象视图对象 employee_flow
 *
 * @author LiuBin
 * @date 2025-10-31
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = EmployeeFlow.class)
public class EmployeeFlowVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 申请编号
     */
    @ExcelProperty(value = "申请编号")
    private String applyCode;

    /**
     * 流程code
     */
    private String flowCode;

    /**
     * 审批类型
     */
    @ExcelProperty(value = "审批类型")
    private String flowType;

    /**
     * 员工信息ID
     */
    @ExcelProperty(value = "员工信息ID")
    private Long employeeId;

    /**
     * 员工姓名
     */
    @ExcelProperty(value = "员工姓名")
    private String name;

    /**
     * 员工部门
     */
    @ExcelProperty(value = "员工部门")
    private String deptName;

    /**
     * 审计内容
     */
    private List<SysAuditLogVo> auditLogList;

    /**
     * 状态
     */
    @ExcelProperty(value = "状态")
    private String status;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remark;


}
