package com.anplus.hr.service.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.anplus.hr.service.EmployeeAuditLogServ;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import top.binfast.common.log.dao.SysAuditLogMapper;
import top.binfast.common.log.model.SysAuditLog;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author 刘斌
 * @date 2025/11/2 20:56
 */
@DS("logSource")
@Service
@RequiredArgsConstructor
public class EmployeeAuditLogServImpl implements EmployeeAuditLogServ {

    private final SysAuditLogMapper auditLogMapper;

    @Override
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public List<SysAuditLog> queryAuditLogs(String flowLogIds) {
        List<Long> logIds = StrUtil.split(flowLogIds, StrUtil.COMMA)
                .stream()
                .filter(Objects::nonNull)
                .map(Convert::toLong)
                .collect(Collectors.toList());
        return auditLogMapper.selectList(new LambdaUpdateWrapper<SysAuditLog>().in(SysAuditLog::getId, logIds));
    }

    @Override
    public Boolean saveAuditLogs(List<SysAuditLog> auditLog) {
        return SqlHelper.retBool(auditLogMapper.insert(auditLog));
    }
}