package com.anplus.hr.service;

import com.alibaba.cola.dto.PageResponse;
import com.anplus.hr.domain.EmployeeChangeLog;
import com.anplus.hr.domain.EmployeeInfo;
import com.anplus.hr.domain.params.EmployeeChangeLogListParam;
import com.anplus.hr.domain.params.EmployeeChangeLogParam;
import com.anplus.hr.domain.vo.EmployeeChangeLogVo;
import com.baomidou.mybatisplus.extension.service.IService;

import java.time.LocalDate;
import java.util.List;

/**
 * 员工异动记录Service接口
 *
 * @author LiuBin
 * @date 2025-11-17
 */
public interface EmployeeChangeLogServ extends IService<EmployeeChangeLog> {


    /**
     * 分页查询员工异动记录列表
     *
     * @param param        查询条件
     * @return 员工异动记录分页列表
     */
    PageResponse<EmployeeChangeLogVo> queryPageList(EmployeeChangeLogListParam param);

    /**
     * 查询符合条件的员工异动记录列表
     *
     * @param param 查询条件
     * @return 员工异动记录列表
     */
    List<EmployeeChangeLogVo> queryList(EmployeeChangeLogListParam param);

    /**
     * 查询员工异动记录
     *
     * @param id 主键
     * @return 员工异动记录
     */
     EmployeeChangeLogVo queryById(Long id);

     /**
     * 新增员工异动记录
     *
     * @param employeeInfo 员工信息
     * @param changeType   变更类型
     * @return 是否新增成功
     */
     Boolean insertByEmployee(EmployeeInfo employeeInfo, LocalDate changeDate, String changeType);

    /**
     * 新增员工异动记录
     *
     * @param param 员工异动记录
     * @return 是否新增成功
     */
    Boolean insertByParam(EmployeeChangeLogParam param);

    /**
     * 修改员工异动记录
     *
     * @param param 员工异动记录
     * @return 是否修改成功
     */
    Boolean updateByParam(EmployeeChangeLogParam param);

    /**
     * 校验并批量删除员工异动记录信息
     *
     * @param ids     待删除的主键集合
     * @return 是否删除成功
     */
    Boolean delByIds(List<Long> ids);

}
