package com.anplus.hr.domain.vo;

import java.time.LocalDateTime;
import cn.idev.excel.annotation.ExcelIgnoreUnannotated;
import cn.idev.excel.annotation.ExcelProperty;
import cn.idev.excel.annotation.ExcelIgnore;
import com.anplus.hr.domain.EmployeeChangeLog;
import top.binfast.common.excel.annotion.ExcelDictFormat;
import top.binfast.common.excel.converters.ExcelDictConvert;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;



/**
 * 员工异动记录视图对象 employee_change_log
 *
 * @author LiuBin
 * @date 2025-11-17
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = EmployeeChangeLog.class)
public class EmployeeChangeLogVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 异动类型
     */
    @ExcelProperty(value = "异动类型", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "HR_CHANGE_LOG_TYPE")
    private String type;

    /**
     * 板块
     */
    @ExcelProperty(value = "板块")
    private String plate;

    /**
     * 部门ID
     */
    @ExcelProperty(value = "部门ID")
    private Long deptId;

    /**
     * 员工ID
     */
    @ExcelProperty(value = "员工ID")
    private Long employeeId;

    /**
     * 异动时间
     */
    @ExcelProperty(value = "异动时间")
    private LocalDateTime changeDate;

    /**
     * 离职类型
     */
    @ExcelProperty(value = "离职类型", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "HR_RESIGNATION_TYPE")
    private String resignType;

    /**
     * 离职工龄类型
     */
    @ExcelProperty(value = "离职工龄类型", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "HR_RESIGN_YEARS_OF_SERVICE_TYPE")
    private String resignYearsOfServiceType;


}
