package com.anplus.hr.domain.params;

import cn.idev.excel.annotation.ExcelProperty;
import com.anplus.hr.domain.EmployeeChangeLog;
import top.binfast.common.core.validate.AddGroup;
import top.binfast.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import jakarta.validation.constraints.*;
import java.time.LocalDateTime;;

/**
 * 员工异动记录业务对象 employee_change_log
 *
 * @author LiuBin
 * @date 2025-11-17
 */
@Data
@AutoMapper(target = EmployeeChangeLog.class, reverseConvertGenerate = false)
public class EmployeeChangeLogParam {

    /**
     * 主键
     */
    @NotNull(message = "主键不能为空", groups = { EditGroup.class })
    private Long id;

    /**
     * 异动类型
     */
    @NotBlank(message = "异动类型不能为空", groups = { AddGroup.class, EditGroup.class })
    private String type;

    /**
     * 板块
     */
    private String plate;

    /**
     * 部门ID
     */
    @NotNull(message = "部门ID不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long deptId;

    /**
     * 员工ID
     */
    @NotNull(message = "员工ID不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long employeeId;

    /**
     * 异动时间
     */
    @NotNull(message = "异动时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDateTime changeDate;

    /**
     * 离职类型
     */
    @NotBlank(message = "离职类型不能为空", groups = { AddGroup.class, EditGroup.class })
    private String resignType;

    /**
     * 离职工龄类型
     */
    @NotBlank(message = "离职工龄类型不能为空", groups = { AddGroup.class, EditGroup.class })
    private String resignYearsOfServiceType;


}
