package com.anplus.hr.domain;

import top.binfast.common.mybatis.bean.model.TenantModel;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;

import java.time.LocalDate;
import java.time.LocalDateTime;

import java.io.Serial;

/**
 * 员工异动记录对象 employee_change_log
 *
 * @author LiuBin
 * @date 2025-11-17
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = true)
@TableName("employee_change_log")
public class EmployeeChangeLog extends TenantModel {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 异动类型
     */
    private String type;

    /**
     * 申请编号
     */
    private String applyCode;

    /**
     * 板块ID
     */
    private Long plateId;

    /**
     * 板块名称
     */
    private String plate;

    /**
     * 部门ID
     */
    private Long deptId;

    /**
     * 员工ID
     */
    private Long employeeId;

    /**
     * 异动时间
     */
    private LocalDate changeDate;

    /**
     * 离职类型 1.主动离职 2.被动离职
     */
    private String resignType;

    /**
     * 离职工龄类型
     */
    private String resignYearsOfServiceType;


}
