
package com.anplus.hr.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.cola.dto.PageResponse;
import com.anplus.hr.constant.HrStatusEnum;
import com.anplus.hr.domain.EmployeeInfo;
import com.anplus.hr.domain.params.EmployeePhoneBookListParam;
import com.anplus.hr.domain.params.EmployeePhoneBookParam;
import com.anplus.hr.domain.vo.EmployeePhoneBookVo;
import com.anplus.hr.mapper.EmployeeInfoMapper;
import com.anplus.hr.service.EmployeePhoneBookServ;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import top.binfast.common.core.util.MapstructUtils;
import top.binfast.common.mybatis.util.QueryUtil;

import java.util.List;

/**
 * 电话本管理Service业务层处理
 *
 * @author LiuBin
 * @date 2025-11-19
 */
@RequiredArgsConstructor
@Service
public class EmployeePhoneBookServImpl extends ServiceImpl<EmployeeInfoMapper, EmployeeInfo> implements EmployeePhoneBookServ {

    private final EmployeeInfoMapper employeeInfoMapper;

    /**
     * 分页查询电话本管理列表
     *
     * @param param 查询条件
     * @return 电话本管理分页列表
     */
    @Override
    public PageResponse<EmployeePhoneBookVo> queryPageList(EmployeePhoneBookListParam param) {
        Page<EmployeeInfo> page = QueryUtil.getPage(param);
        LambdaQueryWrapper<EmployeeInfo> lambdaQuery = this.buildQueryWrapper(param);
        employeeInfoMapper.selectPage(page, lambdaQuery);
        return QueryUtil.getPageResponse(page, MapstructUtils.convert(page.getRecords(), EmployeePhoneBookVo.class));
    }


    /**
     * 查询符合条件的电话本管理列表
     *
     * @param param 查询条件
     * @return 电话本管理列表
     */
    @Override
    public List<EmployeePhoneBookVo> queryList(EmployeePhoneBookListParam param) {
        LambdaQueryWrapper<EmployeeInfo> lambdaQuery = this.buildQueryWrapper(param);
        return MapstructUtils.convert(employeeInfoMapper.selectList(lambdaQuery), EmployeePhoneBookVo.class);
    }

    private LambdaQueryWrapper<EmployeeInfo> buildQueryWrapper(EmployeePhoneBookListParam param) {
        LambdaQueryWrapper<EmployeeInfo> lambdaQuery = Wrappers.<EmployeeInfo>lambdaQuery();
        lambdaQuery.orderByDesc(EmployeeInfo::getId);
        lambdaQuery.ne(EmployeeInfo::getStatus, HrStatusEnum.RESIGN.getStatus());
        lambdaQuery.eq(StrUtil.isNotBlank(param.getPlate()), EmployeeInfo::getPlate, param.getPlate());
        lambdaQuery.eq(StrUtil.isNotBlank(param.getFirstLevelDepartment()), EmployeeInfo::getFirstLevelDepartment, param.getFirstLevelDepartment());
        lambdaQuery.eq(StrUtil.isNotBlank(param.getSecondLevelDepartment()), EmployeeInfo::getSecondLevelDepartment, param.getSecondLevelDepartment());
        lambdaQuery.eq(StrUtil.isNotBlank(param.getThirdLevelDepartment()), EmployeeInfo::getThirdLevelDepartment, param.getThirdLevelDepartment());
        lambdaQuery.eq(param.getDeptId() != null, EmployeeInfo::getDeptId, param.getDeptId());
        lambdaQuery.eq(StrUtil.isNotBlank(param.getPosition()), EmployeeInfo::getPosition, param.getPosition());
        lambdaQuery.like(StrUtil.isNotBlank(param.getName()), EmployeeInfo::getName, param.getName());
        lambdaQuery.eq(StrUtil.isNotBlank(param.getPhoneNumber()), EmployeeInfo::getPhoneNumber, param.getPhoneNumber());
        lambdaQuery.eq(StrUtil.isNotBlank(param.getOfficePhone()), EmployeeInfo::getOfficePhone, param.getOfficePhone());
        lambdaQuery.eq(StrUtil.isNotBlank(param.getShortLine()), EmployeeInfo::getShortLine, param.getShortLine());
        lambdaQuery.eq(StrUtil.isNotBlank(param.getRemarks()), EmployeeInfo::getRemarks, param.getRemarks());
        return lambdaQuery;
    }

    /**
     * 查询电话本管理
     *
     * @param id 主键
     * @return 电话本管理
     */
    @Override
    public EmployeePhoneBookVo queryById(Long id){
        EmployeeInfo employeePhoneBook = employeeInfoMapper.selectById(id);
        return MapstructUtils.convert(employeePhoneBook, EmployeePhoneBookVo.class);
    }

    /**
     * 新增电话本管理
     *
     * @param param 电话本管理
     * @return 是否新增成功
     */
    @Override
    public Boolean insertByParam(EmployeePhoneBookParam param) {
//        EmployeeInfo employeePhoneBook = MapstructUtils.convert(param, EmployeeInfo.class);
//        return this.save(employeePhoneBook);
        return true;
    }

    /**
     * 修改电话本管理
     *
     * @param param 电话本管理
     * @return 是否修改成功
     */
    @Override
    public Boolean updateByParam(EmployeePhoneBookParam param) {
//        EmployeeInfo employeePhoneBook = MapstructUtils.convert(param, EmployeeInfo.class);
//        return this.updateById(employeePhoneBook);
        return true;
    }

    /**
     * 保存前的数据校验
     */
    private void validEntityBeforeSave(EmployeeInfo entity){
        // 做一些数据校验,如唯一约束
    }

    /**
     * 校验并批量删除电话本管理信息
     *
     * @param ids 待删除的主键集合
     * @return 是否删除成功
     */
    @Override
//    @Transactional(rollbackFor = {Exception.class})
    public Boolean delByIds(List<Long> ids) {
        //做一些业务上的校验,判断是否需要校验
//        return this.removeByIds(ids);
        return true;
    }
}
