package com.anplus.hr.domain.params;

import lombok.Getter;
import lombok.Setter;
import top.binfast.common.core.bean.params.PageQueryParam;
import java.util.HashMap;
import java.util.Map;

/**
 * 电话本管理分页对象 employee_phone_book
 *
 * @author LiuBin
 * @date 2025-11-19
 */
@Getter
@Setter
public class EmployeePhoneBookListParam extends PageQueryParam {

    /**
     * 板块
     */
    private String plate;

    /**
     * 一级部门
     */
    private String firstLevelDepartment;

    /**
     * 二级部门
     */
    private String secondLevelDepartment;

    /**
     * 三级部门
     */
    private String thirdLevelDepartment;

    /**
     * 部门ID
     */
    private Long deptId;

    /**
     * 主岗位
     */
    private String position;

    /**
     * 姓名
     */
    private String name;

    /**
     * 手机号码
     */
    private String phoneNumber;

    /**
     * 办公电话
     */
    private String officePhone;

    /**
     * 短线
     */
    private String shortLine;

    /**
     * 备注
     */
    private String remarks;


    private Map<String, Object> params = new HashMap<>();

}
