package com.anplus.hr.domain.params;

import com.anplus.hr.domain.EmployeeInfo;
import io.github.linpeilie.annotations.AutoMapper;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Data;
import top.binfast.common.core.validate.AddGroup;
import top.binfast.common.core.validate.EditGroup;

import java.time.LocalDate;

/**
 * 员工信息业务对象 employee_info
 *
 * @author LiuBin
 * @date 2025-11-13
 */
@Data
@AutoMapper(target = EmployeeInfo.class, reverseConvertGenerate = false)
public class EmployeeInfoParam {

    /**
     * 序号
     */
    @NotNull(message = "序号不能为空", groups = { EditGroup.class })
    private Long id;

    /**
     * 板块
     */
    @NotBlank(message = "板块不能为空", groups = { AddGroup.class, EditGroup.class })
    private String plate;

    /**
     * 一级部门
     */
    @NotBlank(message = "一级部门不能为空", groups = { AddGroup.class, EditGroup.class })
    private String firstLevelDepartment;

    /**
     * 二级部门
     */
    @NotBlank(message = "二级部门不能为空", groups = { AddGroup.class, EditGroup.class })
    private String secondLevelDepartment;

    /**
     * 三级部门
     */
    @NotBlank(message = "三级部门不能为空", groups = { AddGroup.class, EditGroup.class })
    private String thirdLevelDepartment;

    /**
     * 部门ID
     */
    @NotNull(message = "部门ID不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long deptId;

    /**
     * 工号
     */
//    @NotBlank(message = "工号不能为空", groups = { AddGroup.class, EditGroup.class })
    private String employeeId;

    /**
     * 职级
     */
//    @NotNull(message = "职级不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer jobLevel;

    /**
     * 岗位类型
     */
//    @NotBlank(message = "岗位类型不能为空", groups = { AddGroup.class, EditGroup.class })
    private String positionType;

    /**
     * 序列
     */
//    @NotBlank(message = "序列不能为空", groups = { AddGroup.class, EditGroup.class })
    private String sequence;

    /**
     * 主岗位
     */
//    @NotBlank(message = "主岗位不能为空", groups = { AddGroup.class, EditGroup.class })
    private String position;

    /**
     * 姓名
     */
    @NotBlank(message = "姓名不能为空", groups = { AddGroup.class, EditGroup.class })
    private String name;

    /**
     * 性别
     */
    @NotBlank(message = "性别不能为空", groups = { AddGroup.class, EditGroup.class })
    private String gender;

    /**
     * 头像OSS_ID
     */
    private Long ossId;

    /**
     * 身份证号码
     */
    @NotBlank(message = "身份证号码不能为空", groups = { AddGroup.class, EditGroup.class })
    private String idCardNumber;

//    /**
//     * 照片
//     */
//    @NotBlank(message = "照片不能为空", groups = { AddGroup.class, EditGroup.class })
//    private String photo;

    /**
     * 出生日期
     */
    @NotNull(message = "出生日期不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate birthDate;

    /**
     * 年龄
     */
    @NotNull(message = "年龄不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer age;

    /**
     * 年龄段
     */
//    @NotBlank(message = "年龄段不能为空", groups = { AddGroup.class, EditGroup.class })
    private String ageGroup;

    /**
     * 兼职板块
     */
//    @NotBlank(message = "兼职板块不能为空", groups = { AddGroup.class, EditGroup.class })
    private String partTimePlate;

    /**
     * 兼职一级部门
     */
//    @NotBlank(message = "兼职一级部门不能为空", groups = { AddGroup.class, EditGroup.class })
    private String partTimeFirstDept;

    /**
     * 兼职二级部门
     */
//    @NotBlank(message = "兼职二级部门不能为空", groups = { AddGroup.class, EditGroup.class })
    private String partTimeSecondDept;

    /**
     * 兼职三级部门
     */
//    @NotBlank(message = "兼职三级部门不能为空", groups = { AddGroup.class, EditGroup.class })
    private String partTimeThirdDept;

    /**
     * 兼职岗位
     */
//    @NotBlank(message = "兼职岗位不能为空", groups = { AddGroup.class, EditGroup.class })
    private String partTimePosition;

    /**
     * 兼职部门ID
     */
    private Long partDeptId;

    /**
     * 籍贯
     */
//    @NotBlank(message = "籍贯不能为空", groups = { AddGroup.class, EditGroup.class })
    private String nativePlace;

    /**
     * 民族
     */
//    @NotBlank(message = "民族不能为空", groups = { AddGroup.class, EditGroup.class })
    private String ethnicity;

    /**
     * 婚姻状况
     */
//    @NotBlank(message = "婚姻状况不能为空", groups = { AddGroup.class, EditGroup.class })
    private String maritalStatus;

    /**
     * 政治面貌
     */
//    @NotBlank(message = "政治面貌不能为空", groups = { AddGroup.class, EditGroup.class })
    private String politicalStatus;

    /**
     * 手机号码
     */
    @NotBlank(message = "手机号码不能为空", groups = { AddGroup.class, EditGroup.class })
    private String phoneNumber;

    /**
     * 紧急联系人
     */
//    @NotBlank(message = "紧急联系人不能为空", groups = { AddGroup.class, EditGroup.class })
    private String emergencyContact;

    /**
     * 紧急联系人电话
     */
//    @NotBlank(message = "紧急联系人电话不能为空", groups = { AddGroup.class, EditGroup.class })
    private String emergencyContactPhone;

    /**
     * 家庭地址
     */
    @NotBlank(message = "家庭地址不能为空", groups = { AddGroup.class, EditGroup.class })
    private String homeAddress;

    /**
     * 户口所在地
     */
//    @NotBlank(message = "户口所在地不能为空", groups = { AddGroup.class, EditGroup.class })
    private String householdRegistrationAddress;

    /**
     * 参加工作时间
     */
//    @NotNull(message = "参加工作时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate workStartDate;

    /**
     * 入职时间
     */
//    @NotNull(message = "入职时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate entryDate;

    /**
     * 工龄
     */
//    @NotBlank(message = "工龄不能为空", groups = { AddGroup.class, EditGroup.class })
    private String yearsOfService;

    /**
     * 工龄段
     */
//    @NotBlank(message = "工龄段不能为空", groups = { AddGroup.class, EditGroup.class })
    private String yearsOfServiceSegment;

    /**
     * 全日制学历
     */
//    @NotBlank(message = "全日制学历不能为空", groups = { AddGroup.class, EditGroup.class })
    private String fulltimeEducation;

    /**
     * 全日制毕业院校
     */
//    @NotBlank(message = "全日制毕业院校不能为空", groups = { AddGroup.class, EditGroup.class })
    private String fulltimeSchool;

    /**
     * 全日制专业
     */
//    @NotBlank(message = "全日制专业不能为空", groups = { AddGroup.class, EditGroup.class })
    private String fulltimeMajor;

    /**
     * 全日制毕业日期
     */
//    @NotNull(message = "全日制毕业日期不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate fulltimeGraduationDate;

    /**
     * 全日制学位
     */
//    @NotBlank(message = "全日制学位不能为空", groups = { AddGroup.class, EditGroup.class })
    private String fulltimeDegree;

    /**
     * 非全日制学历
     */
//    @NotBlank(message = "非全日制学历不能为空", groups = { AddGroup.class, EditGroup.class })
    private String nonFulltimeEducation;

    /**
     * 非全日制毕业院校
     */
//    @NotBlank(message = "非全日制毕业院校不能为空", groups = { AddGroup.class, EditGroup.class })
    private String nonFulltimeSchool;

    /**
     * 非全日制专业
     */
//    @NotBlank(message = "非全日制专业不能为空", groups = { AddGroup.class, EditGroup.class })
    private String nonFulltimeMajor;

    /**
     * 非全日制毕业日期
     */
//    @NotNull(message = "非全日制毕业日期不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate nonFulltimeGraduationDate;

    /**
     * 非全日制学位
     */
//    @NotBlank(message = "非全日制学位不能为空", groups = { AddGroup.class, EditGroup.class })
    private String nonFulltimeDegree;

    /**
     * 学历分类
     */
//    @NotBlank(message = "学历分类不能为空", groups = { AddGroup.class, EditGroup.class })
    private String educationCategory;

    /**
     * 员工类型
     */
//    @NotBlank(message = "员工类型不能为空", groups = { AddGroup.class, EditGroup.class })
    private String employeeType;

    /**
     * 职称情况
     */
//    @NotBlank(message = "职称情况不能为空", groups = { AddGroup.class, EditGroup.class })
    private String professionalTitle;

    /**
     * 证书情况
     */
//    @NotBlank(message = "证书情况不能为空", groups = { AddGroup.class, EditGroup.class })
    private String certificateStatus;

    /**
     * 外部个人履历
     */
//    @NotBlank(message = "外部个人履历不能为空", groups = { AddGroup.class, EditGroup.class })
    private String externalResume;

    /**
     * 内部个人履历
     */
//    @NotBlank(message = "内部个人履历不能为空", groups = { AddGroup.class, EditGroup.class })
    private String internalResume;

    /**
     * 用工形式
     */
//    @NotBlank(message = "用工形式不能为空", groups = { AddGroup.class, EditGroup.class })
    private String employmentForm;

    /**
     * 合同形式
     */
//    @NotBlank(message = "合同形式不能为空", groups = { AddGroup.class, EditGroup.class })
    private String contractForm;

    /**
     * 劳动合同期限
     */
//    @NotBlank(message = "劳动合同期限不能为空", groups = { AddGroup.class, EditGroup.class })
    private String contractTerm;

    /**
     * 劳动合同开始时间
     */
//    @NotNull(message = "劳动合同开始时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate contractStartDate;

    /**
     * 劳动合同截止时间
     */
//    @NotNull(message = "劳动合同截止时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate contractEndDate;

    /**
     * 合同到期提醒
     */
//    @NotNull(message = "合同到期提醒不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate contractExpirationReminder;

    /**
     * 劳动合同签订情况
     */
//    @NotBlank(message = "劳动合同签订情况不能为空", groups = { AddGroup.class, EditGroup.class })
    private String contractSigningStatus;

    /**
     * 合同主体
     */
//    @NotBlank(message = "合同主体不能为空", groups = { AddGroup.class, EditGroup.class })
    private String contractEntity;

    /**
     * 社保主体
     */
//    @NotBlank(message = "社保主体不能为空", groups = { AddGroup.class, EditGroup.class })
    private String socialSecurityEntity;

    /**
     * 是否缴纳社保
     */
//    @NotBlank(message = "是否缴纳社保不能为空", groups = { AddGroup.class, EditGroup.class })
    private String hasSocialSecurityPaid;

    /**
     * 公积金主体
     */
//    @NotBlank(message = "公积金主体不能为空", groups = { AddGroup.class, EditGroup.class })
    private String providentFundEntity;

    /**
     * 是否缴纳公积金
     */
//    @NotBlank(message = "是否缴纳公积金不能为空", groups = { AddGroup.class, EditGroup.class })
    private String hasProvidentFundPaid;

    /**
     * 试用期（月数）
     */
//    @NotNull(message = "试用期（月数）不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer probationPeriod;

    /**
     * 转正时间
     */
//    @NotNull(message = "转正时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate regularizationDate;

    /**
     * 奖励情况
     */
//    @NotBlank(message = "奖励情况不能为空", groups = { AddGroup.class, EditGroup.class })
    private String rewardStatus;

    /**
     * 处罚情况
     */
//    @NotBlank(message = "处罚情况不能为空", groups = { AddGroup.class, EditGroup.class })
    private String punishmentStatus;

    /**
     * 备注
     */
//    @NotBlank(message = "备注不能为空", groups = { AddGroup.class, EditGroup.class })
    private String remarks;

    /**
     * 办公电话
     */
//    @NotBlank(message = "办公电话不能为空", groups = { AddGroup.class, EditGroup.class })
    private String officePhone;

    /**
     * 短线
     */
//    @NotBlank(message = "短线不能为空", groups = { AddGroup.class, EditGroup.class })
    private String shortLine;

    /**
     * 银行卡号
     */
//    @NotBlank(message = "银行卡号不能为空", groups = { AddGroup.class, EditGroup.class })
    private String bankCardNumber;

    /**
     * 开户行
     */
//    @NotBlank(message = "开户行不能为空", groups = { AddGroup.class, EditGroup.class })
    private String bankName;

    /**
     * 公司内是否有亲属关系
     */
//    @NotBlank(message = "公司内是否有亲属关系不能为空", groups = { AddGroup.class, EditGroup.class })
    private String hasRelativeInCompany;

    /**
     * 亲属姓名
     */
//    @NotBlank(message = "亲属姓名不能为空", groups = { AddGroup.class, EditGroup.class })
    private String relativeName;

    /**
     * 介绍人
     */
//    @NotBlank(message = "介绍人不能为空", groups = { AddGroup.class, EditGroup.class })
    private String introducer;

    /**
     * 工资发放地
     */
//    @NotBlank(message = "工资发放地不能为空", groups = { AddGroup.class, EditGroup.class })
    private String salaryLocation;

    /**
     * 绩效比例
     */
//    @NotNull(message = "绩效比例不能为空", groups = { AddGroup.class, EditGroup.class })
    private String performanceRatio;

    /**
     * 离职类型
     */
//    @NotBlank(message = "离职类型不能为空", groups = { AddGroup.class, EditGroup.class })
    private String resignationType;

    /**
     * 离职时间
     */
//    @NotNull(message = "离职时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate resignationDate;

    /**
     * 离职原因
     */
//    @NotBlank(message = "离职原因不能为空", groups = { AddGroup.class, EditGroup.class })
    private String resignationReason;

    /**
     * 最后结薪日
     */
//    @NotNull(message = "最后结薪日不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate finalPayDate;

    /**
     * 离职申请状态
     */
//    @NotNull(message = "离职申请状态不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer resignationApplyStatus;

    /**
     * 入职审批状态
     */
//    @NotNull(message = "入职审批状态不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer entryApplyStatus;

    /**
     * 调配申请状态
     */
//    @NotNull(message = "调配申请状态不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer transferApplyStatus;


}
