package com.anplus.hr.domain.vo;

import cn.idev.excel.annotation.ExcelIgnore;
import cn.idev.excel.annotation.ExcelIgnoreUnannotated;
import cn.idev.excel.annotation.ExcelProperty;
import cn.idev.excel.annotation.write.style.ColumnWidth;
import cn.idev.excel.annotation.write.style.ContentRowHeight;
import cn.idev.excel.annotation.write.style.HeadRowHeight;
import com.anplus.hr.domain.EmployeeInfo;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDate;



/**
 * 员工合同续签提醒视图对象 employee_contract_expiration_reminder
 *
 * @author LiuBin
 * @date 2025-11-20
 */
@Data
@ExcelIgnoreUnannotated
@ContentRowHeight(30)
@HeadRowHeight(32)
@ColumnWidth(20)
@AutoMapper(target = EmployeeInfo.class)
public class ContractExpirationReminderVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 板块
     */
    @ExcelProperty(value = {"合同续签提醒", "板块"})
    private String plate;

    /**
     * 一级部门
     */
    @ExcelProperty(value = {"合同续签提醒", "一级部门"})
    private String firstLevelDepartment;

    /**
     * 二级部门
     */
    @ExcelProperty(value = {"合同续签提醒", "二级部门"})
    private String secondLevelDepartment;

    /**
     * 三级部门
     */
    @ExcelProperty(value = {"合同续签提醒", "三级部门"})
    private String thirdLevelDepartment;

    /**
     * 部门ID
     */
    @ExcelIgnore
    private Long deptId;

    /**
     * 主岗位
     */
    @ExcelProperty(value = {"合同续签提醒", "主岗位"})
    private String position;

    /**
     * 姓名
     */
    @ExcelProperty(value = {"合同续签提醒", "姓名"})
    private String name;

    /**
     * 手机号码
     */
    @ExcelProperty(value = {"合同续签提醒", "手机号码"})
    private String phoneNumber;

    /**
     * 劳动合同开始时间
     */
    @ExcelProperty(value = {"合同续签提醒", "合同开始时间"})
    private LocalDate contractStartDate;

    /**
     * 劳动合同截止时间
     */
    @ExcelProperty(value = {"合同续签提醒", "合同截止时间"})
    private LocalDate contractEndDate;

    /**
     * 合同形式
     */
    @ExcelProperty(value = {"合同续签提醒", "合同形式"})
    private String contractForm;

    /**
     * 备注
     */
    @ExcelProperty(value = {"合同续签提醒", "备注"})
    private String remarks;


}
