package com.anplus.hr.domain.params;

import lombok.Getter;
import lombok.Setter;
import top.binfast.common.core.bean.params.PageQueryParam;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;

;

/**
 * 员工变动记录分页对象 employee_change_log
 *
 * @author LiuBin
 * @date 2025-11-24
 */
@Getter
@Setter
public class EmployeeChangeLogListParam extends PageQueryParam {

    /**
     * 变动类型
     */
    private String type;

    /**
     * 流程申请编号
     */
    private String applyCode;

    /**
     * 板块ID
     */
    private Long plateId;

    /**
     * 板块
     */
    private String plate;

    /**
     * 部门ID
     */
    private Long deptId;

    /**
     * 员工ID
     */
    private Long employeeId;

    /**
     * 变动时间
     */
    private LocalDate changeDate;

    /**
     * 离职类型
     */
    private String resignType;

    /**
     * 离职工龄类型
     */
    private String resignYearsOfServiceType;

    /**
     * 归属部门id（部门树）
     */
    private Long belongDeptId;


    private Map<String, Object> params = new HashMap<>();

}
