package com.anplus.hr.service;

import com.anplus.hr.domain.StaffingPlanRecords;
import com.anplus.hr.domain.vo.StaffingPlanRecordsVo;
import com.anplus.hr.domain.params.StaffingPlanRecordsListParam;
import com.anplus.hr.domain.params.StaffingPlanRecordsParam;
import com.alibaba.cola.dto.PageResponse;
import com.baomidou.mybatisplus.extension.service.IService;
import java.util.List;

/**
 * 编制规划记录Service接口
 *
 * @author LiuBin
 * @date 2025-12-14
 */
public interface StaffingPlanRecordsServ extends IService<StaffingPlanRecords> {


    /**
     * 分页查询编制规划记录列表
     *
     * @param param        查询条件
     * @return 编制规划记录分页列表
     */
    PageResponse<StaffingPlanRecordsVo> queryPageList(StaffingPlanRecordsListParam param);

    /**
     * 查询符合条件的编制规划记录列表
     *
     * @param param 查询条件
     * @return 编制规划记录列表
     */
    List<StaffingPlanRecordsVo> queryList(StaffingPlanRecordsListParam param);

    /**
     * 查询编制规划记录
     *
     * @param id 主键
     * @return 编制规划记录
     */
     StaffingPlanRecordsVo queryById(Long id);

    /**
     * 新增编制规划记录
     *
     * @param param 编制规划记录
     * @return 是否新增成功
     */
    Boolean insertByParam(StaffingPlanRecordsParam param);

    /**
     * 修改编制规划记录
     *
     * @param param 编制规划记录
     * @return 是否修改成功
     */
    Boolean updateByParam(StaffingPlanRecordsParam param);

    /**
     * 校验并批量删除编制规划记录信息
     *
     * @param ids     待删除的主键集合
     * @return 是否删除成功
     */
    Boolean delByIds(List<Long> ids);

}
