package com.anplus.hr.service;

import com.alibaba.cola.dto.PageResponse;
import com.alibaba.cola.dto.Response;
import com.anplus.hr.domain.EmployeeInfo;
import com.anplus.hr.domain.params.EmployeePartTimeInfoListParam;
import com.anplus.hr.domain.params.EmployeePartTimeInfoParam;
import com.anplus.hr.domain.vo.EmployeePartTimeInfoImportVo;
import com.anplus.hr.domain.vo.EmployeePartTimeInfoVo;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;
import java.util.stream.Stream;

/**
 * 兼职员工信息Service接口
 *
 * @author LiuBin
 * @date 2025-12-10
 */
public interface EmployeePartTimeInfoServ extends IService<EmployeeInfo> {


    /**
     * 分页查询兼职员工信息列表
     *
     * @param param 查询条件
     * @return 兼职员工信息分页列表
     */
    PageResponse<EmployeePartTimeInfoVo> queryPageList(EmployeePartTimeInfoListParam param);

    /**
     * 查询符合条件的兼职员工信息列表
     *
     * @param param 查询条件
     * @return 兼职员工信息列表
     */
    List<EmployeePartTimeInfoVo> queryList(EmployeePartTimeInfoListParam param);

    /**
     * 导入兼职员工信息列表
     *
     * @param stream 员工信息列表
     * @return 是否导入成功
     */
    Response importPartTimeEmployeeList(Stream<EmployeePartTimeInfoImportVo> stream);

    /**
     * 查询兼职员工信息
     *
     * @param id 主键
     * @return 兼职员工信息
     */
    EmployeePartTimeInfoVo queryById(Long id);

    /**
     * 员工信息详情
     *
     * @param id 主键
     * @return 员工信息
     */
    EmployeePartTimeInfoVo infoDetail(Long id);

    /**
     * 新增兼职员工信息
     *
     * @param param 兼职员工信息
     * @return 是否新增成功
     */
    Boolean insertByParam(EmployeePartTimeInfoParam param);

    /**
     * 修改兼职员工信息
     *
     * @param param 兼职员工信息
     * @return 是否修改成功
     */
    Boolean updateByParam(EmployeePartTimeInfoParam param);

    /**
     * 校验并批量删除兼职员工信息信息
     *
     * @param ids 待删除的主键集合
     * @return 是否删除成功
     */
    Boolean delByIds(List<Long> ids);

}
