package com.anplus.hr.mapper;

import com.anplus.hr.domain.EmployeeTraining;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import top.binfast.common.mybatis.mapper.BinBaseMapper;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * 员工培训档案Mapper接口
 *
 * @author LiuBin
 * @date 2025-12-07
 */
@Mapper
public interface EmployeeTrainingMapper extends BinBaseMapper<EmployeeTraining> {

    default List<EmployeeTraining> selectListByEmployeeId(Long employeeId) {
        return selectList(new LambdaUpdateWrapper<EmployeeTraining>().eq(EmployeeTraining::getEmployeeId, employeeId));
    }

}
