package com.anplus.hr.domain.vo;

import cn.idev.excel.annotation.ExcelIgnoreUnannotated;
import cn.idev.excel.annotation.ExcelProperty;
import com.anplus.hr.constant.HrConstant;
import com.anplus.hr.domain.EmployeeInfo;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.core.trans.anno.Trans;
import org.dromara.core.trans.constant.TransType;
import top.binfast.common.excel.annotion.ExcelDictFormat;
import top.binfast.common.excel.converters.ExcelDictConvert;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * @author 刘斌
 * @date 2025/12/12 09:10
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = EmployeeInfo.class, convertGenerate = false)
public class EmployeePartTimeInfoDetailVo extends EmployeeInfoVo implements Serializable {
    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 是否兼职
     */
//    @ExcelProperty(value = "是否兼职")
    private String partTimeFlag;

    /**
     * 签订兼职协议
     */
    @ExcelProperty(value = "签订兼职协议", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.SYS_YES_NO)
    @Trans(type = TransType.DICTIONARY, key = HrConstant.SYS_YES_NO)
    private String partTimeAgreement;

    /**
     * 协议主体
     */
    @ExcelProperty(value = "协议主体")
    private String agreementEntity;

    /**
     * 协议期限
     */
    @ExcelProperty(value = "协议期限")
    private String agreementPeriod;

    /**
     * 协议开始时间
     */
    @ExcelProperty(value = "协议开始时间")
    private LocalDate agreementStartDate;

    /**
     * 协议截止时间
     */
    @ExcelProperty(value = "协议截止时间")
    private LocalDate agreementEndDate;

}
