package com.anplus.hr.domain.params;

import com.anplus.hr.domain.StaffingPlanRecords;
import top.binfast.common.core.validate.AddGroup;
import top.binfast.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import jakarta.validation.constraints.*;

/**
 * 编制规划记录业务对象 staffing_plan_records
 *
 * @author LiuBin
 * @date 2025-12-14
 */
@Data
@AutoMapper(target = StaffingPlanRecords.class, reverseConvertGenerate = false)
public class StaffingPlanRecordsParam {

    /**
     * 主键
     */
    @NotNull(message = "主键不能为空", groups = { EditGroup.class })
    private Long id;

    /**
     * 记录时间
     */
    @NotBlank(message = "记录时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private String recordDate;

    /**
     * 上一年标题
     */
//    @NotBlank(message = "上一年标题不能为空", groups = { AddGroup.class, EditGroup.class })
    private String lastYearTitle;

    /**
     * 今年标题
     */
//    @NotBlank(message = "今年标题不能为空", groups = { AddGroup.class, EditGroup.class })
    private String currentYearTitle;

    /**
     * 明年标题
     */
//    @NotBlank(message = "明年标题不能为空", groups = { AddGroup.class, EditGroup.class })
    private String nextYearTitle;

    /**
     * 是否已初始化
     */
//    @NotBlank(message = "是否已初始化不能为空", groups = { AddGroup.class, EditGroup.class })
    private String initFlag;

    /**
     * 备注
     */
//    @NotBlank(message = "备注不能为空", groups = { AddGroup.class, EditGroup.class })
    private String remark;


}
