package com.anplus.hr.domain.params;

import com.anplus.hr.domain.EmployeeLaborCost;
import top.binfast.common.core.validate.AddGroup;
import top.binfast.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import jakarta.validation.constraints.*;
import java.time.LocalDate;

/**
 * 人工成本档案业务对象 employee_labor_cost
 *
 * @author LiuBin
 * @date 2025-12-09
 */
@Data
@AutoMapper(target = EmployeeLaborCost.class, reverseConvertGenerate = false)
public class EmployeeLaborCostParam {

    /**
     * 主键
     */
    @NotNull(message = "主键不能为空", groups = { EditGroup.class })
    private Long id;

    /**
     * 记录时间
     */
    @NotNull(message = "记录时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate recordDate;

    /**
     * 文件ID
     */
    @NotNull(message = "文件ID不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long ossId;

    /**
     * 文件Key
     */
//    @NotBlank(message = "文件Key不能为空", groups = { AddGroup.class, EditGroup.class })
    private String fileKey;

    /**
     * 备注
     */
//    @NotBlank(message = "备注不能为空", groups = { AddGroup.class, EditGroup.class })
    private String remark;


}
