package com.anplus.hr.domain.params;

import com.anplus.hr.domain.EmployeeFamilyMembers;
import top.binfast.common.core.validate.AddGroup;
import top.binfast.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import jakarta.validation.constraints.*;

/**
 * 员工家庭主要成员业务对象 employee_family_members
 *
 * @author LiuBin
 * @date 2025-12-04
 */
@Data
@AutoMapper(target = EmployeeFamilyMembers.class, reverseConvertGenerate = false)
public class EmployeeFamilyMembersParam {

    /**
     * 序号
     */
//    @NotNull(message = "序号不能为空", groups = { EditGroup.class })
    private Long id;

    /**
     * 员工信息ID
     */
//    @NotNull(message = "员工信息ID不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long employeeId;

    /**
     * 关系
     */
    @NotBlank(message = "关系不能为空", groups = { AddGroup.class, EditGroup.class })
    private String relation;

    /**
     * 姓名
     */
    @NotBlank(message = "姓名不能为空", groups = { AddGroup.class, EditGroup.class })
    private String name;

    /**
     * 出生年月
     */
    @NotBlank(message = "出生年月不能为空", groups = { AddGroup.class, EditGroup.class })
    private String birthDate;

    /**
     * 工作单位及职务
     */
    @NotBlank(message = "工作单位及职务不能为空", groups = { AddGroup.class, EditGroup.class })
    private String companyAndJob;

    /**
     * 联系方式
     */
    @NotBlank(message = "联系方式不能为空", groups = { AddGroup.class, EditGroup.class })
    private String contact;

    /**
     * 是否为紧急联系人
     */
//    @NotBlank(message = "是否为紧急联系人不能为空", groups = { AddGroup.class, EditGroup.class })
    private String emergencyFlag;


}
