package com.anplus.hr.domain;

import top.binfast.common.mybatis.bean.model.TenantModel;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;

import java.io.Serial;

/**
 * 编制规划记录对象 staffing_plan_records
 *
 * @author LiuBin
 * @date 2025-12-14
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = true)
@TableName("staffing_plan_records")
public class StaffingPlanRecords extends TenantModel {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 记录时间
     */
    private String recordDate;

    /**
     * 上一年标题
     */
    private String lastYearTitle;

    /**
     * 今年标题
     */
    private String currentYearTitle;

    /**
     * 明年标题
     */
    private String nextYearTitle;

    /**
     * 是否已初始化
     */
    private String initFlag;

    /**
     * 备注
     */
    private String remark;


}
