package com.anplus.hr.domain;

import top.binfast.common.mybatis.bean.model.TenantModel;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import java.math.BigDecimal;
import java.time.LocalDate;

import java.io.Serial;

/**
 * 员工培训档案对象 employee_training
 *
 * @author LiuBin
 * @date 2025-12-07
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = true)
@TableName("employee_training")
public class EmployeeTraining extends TenantModel {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 员工信息ID
     */
    private Long employeeId;

    /**
     * 姓名
     */
    private String name;

    /**
     * 身份证号
     */
    private String idCardNumber;

    /**
     * 培训课程
     */
    private String trainingCourse;

    /**
     * 培训机构
     */
    private String trainingInstitution;

    /**
     * 培训讲师
     */
    private String trainer;

    /**
     * 参训时间
     */
    private LocalDate trainingTime;

    /**
     * 服务期
     */
    private LocalDate serviceEndDate;

    /**
     * 服务年限
     */
    private String serviceYears;

    /**
     * 培训金额
     */
    private BigDecimal trainingAmount;

    /**
     * 备注
     */
    private String remark;


}
