package com.anplus.hr.domain;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import top.binfast.common.mybatis.bean.model.TenantModel;

import java.io.Serial;
import java.time.LocalDateTime;

/**
 * 人事审批对象对象 employee_flow
 *
 * @author LiuBin
 * @date 2025-10-31
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = true)
@TableName("employee_flow")
public class EmployeeFlow extends TenantModel {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 申请编号
     */
    private String applyCode;

    /**
     * 审批类型
     */
    private String flowType;

    /**
     * 员工信息ID
     */
    private Long employeeId;

    /**
     * 开始时间
     */
    private LocalDateTime startDate;

    /**
     * 结束时间
     */
    private LocalDateTime endDate;

    /**
     * 状态
     */
    private String status;

    /**
     * 审批日志ID，如（1,2）
     */
    private String logIds;

    /**
     * 处理人信息
     */
    private String handlerMessage;

    /**
     * 备注
     */
    private String remark;


}
