package com.anplus.hr.controller;

import cn.dev33.satoken.annotation.SaIgnore;
import com.alibaba.cola.dto.Response;
import com.anplus.hr.domain.params.EmployeeBaseInfoParam;
import com.anplus.hr.domain.params.EmployeeInfoParam;
import com.anplus.hr.service.EmployeeInfoServ;
import jakarta.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import top.binfast.common.core.constant.BusinessType;
import top.binfast.common.core.enums.ResultCode;
import top.binfast.common.core.util.ResponseUtils;
import top.binfast.common.idempotent.annotation.NoRepeatSubmit;
import top.binfast.common.log.annotation.PinSysLog;

/**
 * @author 刘斌
 * @date 2025/11/25 21:03
 */
@RestController
@RequestMapping("/employee/baseInfo")
public class EmployeeBaseInfoForH5Ctrl {

    @Resource
    private EmployeeInfoServ employeeInfoServ;


    /**
     * 新增基础员工信息
     */
    @SaIgnore
    @NoRepeatSubmit
//    @SaCheckPermission("employee:info:add")
    @PinSysLog(value = "基础员工信息", businessType = BusinessType.INSERT)
    @PostMapping()
    public Response addBaseInfo(@RequestBody EmployeeBaseInfoParam param) {
        if (employeeInfoServ.checkEmployeeIdCardNumberUnique(param.getIdCardNumber(), null)) {
            return Response.buildFailure(ResultCode.FAIL.getCode(), "员工身份证号已存在");
        }
        return ResponseUtils.ofResult(employeeInfoServ.insertBaseInfoForH5(param));
    }
}
