package com.anplus.hr.constant;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author 刘斌
 * @date 2025/11/19 11:17
 * 员工生命周期状态
 * 用于报表统计
 */
@Getter
@AllArgsConstructor
public enum HrStatusEnum {

    /**
     * 草稿
     */
    DRAFT(0, "草稿"),

    /**
     * 已入职
     */
    ENTRY(1, "已入职"),

    /**
     * 已转正
     */
    REGULARIZATION(2, "已转正"),
//    TRANSFER(2, "已完成"),
//    RENEWAL_CONTRACT(2, "已完成"),

    /**
     * 已离职
     */
    RESIGN(8, "已离职");

    /**
     * 状态
     */
    private final Integer status;

    /**
     * 描述
     */
    private final String desc;

    private static final Map<Integer, HrStatusEnum> STATUS_MAP = Arrays.stream(HrStatusEnum.values())
            .collect(Collectors.toConcurrentMap(HrStatusEnum::getStatus, Function.identity()));
}
