package com.anplus.hr.config;

import cn.hutool.core.date.LocalDateTimeUtil;
import com.anplus.hr.constant.HrAgeGroupEnum;
import com.anplus.hr.constant.HrEmployeeConstants;
import com.anplus.hr.constant.HrYearsOfServiceSegmentEnum;
import com.anplus.hr.domain.EmployeeInfo;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;

/**
 * @author 刘斌
 * @date 2025/11/25 21:16
 */
public class EmployeeInfoCalcUtils {

    /**
     * 计算预计转正时间
     */
    public static boolean calcExpectedRegularDate(EmployeeInfo employeeInfo) {
        boolean isUpdate = false;
        if (HrEmployeeConstants.EMPLOYEE_TYPE_REGULAR.equals(employeeInfo.getEmployeeType())) {
            return false;
        }
        if (employeeInfo.getEntryDate() != null && employeeInfo.getProbationPeriod() != null) {
            employeeInfo.setExpectedRegularDate(employeeInfo.getEntryDate().plusMonths(employeeInfo.getProbationPeriod()));
            isUpdate = true;
        }
        return isUpdate;
    }

    /**
     * 计算员工年龄组
     */
    public static boolean calcAgeGroup(EmployeeInfo employeeInfo) {
        boolean isUpdate = false;
        if (employeeInfo.getBirthDate() == null) {
            return false;
        }
        Period period = LocalDateTimeUtil.betweenPeriod(employeeInfo.getBirthDate(), LocalDate.from(LocalDateTime.now()));
        int years = period.getYears();
        // 更新员工年龄组
        if (employeeInfo.getAge() == null || employeeInfo.getAge() != years) {
            isUpdate = true;
            employeeInfo.setAge(years);
            HrAgeGroupEnum ageGroupEnum = HrAgeGroupEnum.getByAge(employeeInfo.getAge());
            if (ageGroupEnum != null) {
                employeeInfo.setAgeGroup(ageGroupEnum.getCode());
            }
        } else if (employeeInfo.getAgeGroup() == null) {
            HrAgeGroupEnum ageGroupEnum = HrAgeGroupEnum.getByAge(employeeInfo.getAge());
            if (ageGroupEnum != null) {
                employeeInfo.setAgeGroup(ageGroupEnum.getCode());
                isUpdate = true;
            }
        }
        return isUpdate;
    }

    /**
     * 计算员工工龄
     */
    public static boolean calcYearsOfService(EmployeeInfo employeeInfo) {
        boolean isUpdate = false;
        if (employeeInfo.getEntryDate() != null) {
            int newTotalMonths = SeniorityUtils.calculateTotalMonths(employeeInfo.getEntryDate());
            if (employeeInfo.getYearsOfServiceMonths() == null || employeeInfo.getYearsOfServiceMonths() != newTotalMonths) {
                employeeInfo.setYearsOfServiceMonths(newTotalMonths);
                employeeInfo.setYearsOfService(SeniorityUtils.formatMonthsToSeniority(newTotalMonths));
                // 更新员工工龄组
                HrYearsOfServiceSegmentEnum yearsOfServiceSegmentEnum = HrYearsOfServiceSegmentEnum.getByTotalMonths(newTotalMonths);
                if (yearsOfServiceSegmentEnum != null) {
                    employeeInfo.setYearsOfServiceSegment(yearsOfServiceSegmentEnum.getCode());
                }
                isUpdate = true;
            }
        }
        return isUpdate;
    }

}
