package com.anplus.hr.domain.params;

import lombok.Getter;
import lombok.Setter;
import top.binfast.common.core.bean.params.PageQueryParam;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;

/**
 * 转正提醒分页对象 employee_regular_reminder
 *
 * @author LiuBin
 * @date 2025-11-20
 */
@Getter
@Setter
public class EmployeeRegularReminderListParam extends PageQueryParam {

    /**
     * 板块
     */
    private String plate;

    /**
     * 一级部门
     */
    private String firstLevelDepartment;

    /**
     * 二级部门
     */
    private String secondLevelDepartment;

    /**
     * 三级部门
     */
    private String thirdLevelDepartment;

    /**
     * 部门ID
     */
    private Long deptId;

    /**
     * 主岗位
     */
    private String position;

    /**
     * 姓名
     */
    private String name;

    /**
     * 手机号码
     */
    private String phoneNumber;

    /**
     * 入职时间
     */
    private LocalDate entryDate;

    /**
     * 转正时间
     */
    private LocalDate expectedRegularDate;

    /**
     * 归属部门id（部门树）
     */
    private Long belongDeptId;


    private Map<String, Object> params = new HashMap<>();

}
