package com.anplus.hr.domain.params;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.time.LocalDate;

/**
 * 续签合同申请参数
 * @author 刘斌
 * @date 2025/11/18 11:36
 *
 * ！！！需要自动填写的字段！！！
 * 劳动合同期限：开始时间-结束时间
 * 合同到期提醒：结束时间减一个月
 */
@Data
public class EmployeeRenewalContractApplyParam {

    private Long id;

    /**
     * 合同形式
     */
    @NotBlank(message = "合同形式不能为空")
    private String contractForm;

    /**
     * 劳动合同开始时间
     */
    @NotNull(message = "劳动合同开始时间不能为空")
    private LocalDate contractStartDate;

    /**
     * 劳动合同截止时间
     */
    @NotNull(message = "劳动合同截止时间不能为空")
    private LocalDate contractEndDate;

    /**
     * 劳动合同签订情况
     */
    private String contractSigningStatus;


    private String remark;
}
