package com.anplus.hr.domain.vo;

import cn.idev.excel.annotation.ExcelIgnore;
import cn.idev.excel.annotation.ExcelIgnoreUnannotated;
import cn.idev.excel.annotation.ExcelProperty;
import cn.idev.excel.annotation.write.style.ColumnWidth;
import cn.idev.excel.annotation.write.style.ContentRowHeight;
import cn.idev.excel.annotation.write.style.HeadRowHeight;
import com.anplus.hr.domain.EmployeeInfo;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDate;


/**
 * 转正提醒视图对象 employee_regular_reminder
 *
 * @author LiuBin
 * @date 2025-11-20
 */
@Data
@ExcelIgnoreUnannotated
@ContentRowHeight(30)
@HeadRowHeight(32)
@ColumnWidth(20)
@AutoMapper(target = EmployeeInfo.class)
public class EmployeeRegularReminderVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 板块
     */
    @ExcelProperty(value = {"转正提醒", "板块"})
    private String plate;

    /**
     * 一级部门
     */
    @ExcelProperty(value = {"转正提醒", "一级部门"})
    private String firstLevelDepartment;

    /**
     * 二级部门
     */
    @ExcelProperty(value = {"转正提醒", "二级部门"})
    private String secondLevelDepartment;

    /**
     * 三级部门
     */
    @ExcelProperty(value = {"转正提醒", "三级部门"})
    private String thirdLevelDepartment;

    /**
     * 部门ID
     */
    @ExcelIgnore
    private Long deptId;

    /**
     * 主岗位
     */
    @ExcelProperty(value = {"转正提醒", "主岗位"})
    private String position;

    /**
     * 姓名
     */
    @ExcelProperty(value = {"转正提醒", "姓名"})
    private String name;

    /**
     * 手机号码
     */
    @ExcelProperty(value = {"转正提醒", "手机"})
    private String phoneNumber;

    /**
     * 入职时间
     */
    @ExcelProperty(value = {"转正提醒", "入职时间"})
    private LocalDate entryDate;

    /**
     * 转正时间
     */
    @ExcelProperty(value = {"转正提醒", "转正时间"})
    private LocalDate expectedRegularDate;

    /**
     * 备注
     */
    @ExcelProperty(value = {"转正提醒", "备注"})
    private String remarks;


}
