package com.anplus.hr.domain.vo;

import cn.idev.excel.annotation.ExcelIgnore;
import cn.idev.excel.annotation.ExcelProperty;
import com.anplus.hr.config.SeniorityUtils;
import com.anplus.hr.constant.HrConstant;
import com.anplus.hr.domain.EmployeeInfo;
import com.anplus.hr.domain.params.EmployeeInfoParam;
import io.github.linpeilie.annotations.AutoMapper;
import io.github.linpeilie.annotations.AutoMappers;
import jakarta.validation.constraints.NotBlank;
import lombok.Getter;
import top.binfast.common.core.validate.AddGroup;
import top.binfast.common.core.validate.EditGroup;
import top.binfast.common.excel.annotion.ExcelDictFormat;
import top.binfast.common.excel.bean.ExcelBaseEntity;
import top.binfast.common.excel.converters.ExcelDictConvert;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * @author 刘斌
 * @date 2025/10/29 09:42
 */
@Getter
@AutoMappers({
        @AutoMapper(target = EmployeeInfo.class, reverseConvertGenerate = false),
        @AutoMapper(target = EmployeeInfoParam.class, reverseConvertGenerate = false)
})
public class EmployeeInfoImportVo extends ExcelBaseEntity implements Serializable {
    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 板块
     */
    @NotBlank(message = "板块不能为空", groups = { AddGroup.class })
    @ExcelProperty(value = "板块")
    private String plate;

    /**
     * 一级部门
     */
    @NotBlank(message = "一级部门不能为空", groups = { AddGroup.class })
    @ExcelProperty(value = "一级部门")
    private String firstLevelDepartment;

    /**
     * 二级部门
     */
    @ExcelProperty(value = "二级部门")
    private String secondLevelDepartment;

    /**
     * 三级部门
     */
    @ExcelProperty(value = "三级部门")
    private String thirdLevelDepartment;

//    /**
//     * 部门ID
//     */
//    @ExcelProperty(value = "部门ID")
//    private Long deptId;

    /**
     * 工号
     */
    @ExcelProperty(value = "工号")
    private String employeeNo;

    /**
     * 职级
     */
    @ExcelProperty(value = "职级")
//    @ExcelDictFormat(dictType = "HR_JOB_LEVEL")
    private Integer jobLevel;

    /**
     * 岗位类型
     */
    @ExcelProperty(value = "岗位类型", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_POSITION_TYPE)
    private String positionType;

    /**
     * 序列
     */
    @ExcelProperty(value = "序列", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_SEQUENCE)
    private String sequence;

    /**
     * 主岗位
     */
    @ExcelProperty(value = "主岗位")
    private String position;

    /**
     * 姓名
     */
    @NotBlank(message = "姓名不能为空", groups = { AddGroup.class })
    @ExcelProperty(value = "姓名")
    private String name;

    /**
     * 性别
     */
    @ExcelProperty(value = "性别", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_USER_SEX)
    private String gender;

    /**
     * 身份证号码
     */
    @NotBlank(message = "身份证号码不能为空", groups = { AddGroup.class, EditGroup.class })
    @ExcelProperty(value = "身份证号码")
    private String idCardNumber;

    /**
     * 照片
     */
    @ExcelProperty(value = "照片")
    private String photo;

    /**
     * 出生日期
     */
    @ExcelProperty(value = "出生日期")
    private LocalDate birthDate;

    /**
     * 年龄
     */
    @ExcelProperty(value = "年龄")
    private Integer age;

    /**
     * 年龄段
     */
    @ExcelProperty(value = "年龄段", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_AGE_GROUP)
    private String ageGroup;

    /**
     * 兼职板块
     */
    @ExcelProperty(value = "兼职板块")
    private String partTimePlate;

    /**
     * 兼职一级部门
     */
    @ExcelProperty(value = "兼职一级部门")
    private String partTimeFirstDept;

    /**
     * 兼职二级部门
     */
    @ExcelProperty(value = "兼职二级部门")
    private String partTimeSecondDept;

    /**
     * 兼职三级部门
     */
    @ExcelProperty(value = "兼职三级部门")
    private String partTimeThirdDept;

    /**
     * 兼职岗位
     */
    @ExcelProperty(value = "兼职岗位")
    private String partTimePosition;

    /**
     * 籍贯
     */
    @ExcelProperty(value = "籍贯")
    private String nativePlace;

    /**
     * 民族
     */
    @ExcelProperty(value = "民族")
    private String ethnicity;

    /**
     * 婚姻状况
     */
    @ExcelProperty(value = "婚姻状况", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_MARITAL_STATUS)
    private String maritalStatus;

    /**
     * 政治面貌
     */
    @ExcelProperty(value = "政治面貌", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_POLITICAL_STATUS)
    private String politicalStatus;

    /**
     * 手机号码
     */
    @ExcelProperty(value = "手机号码")
    private String phoneNumber;

    /**
     * 紧急联系人
     */
    @ExcelProperty(value = "紧急联系人")
    private String emergencyContact;

    /**
     * 紧急联系人电话
     */
    @ExcelProperty(value = "紧急联系人电话")
    private String emergencyContactPhone;

    /**
     * 家庭地址
     */
    @ExcelProperty(value = "家庭地址")
    private String homeAddress;

    /**
     * 户口所在地
     */
    @ExcelProperty(value = "户口所在地")
    private String householdRegistrationAddress;

    /**
     * 参加工作时间
     */
    @ExcelProperty(value = "参加工作时间")
    private LocalDate workStartDate;

    /**
     * 入职时间
     */
    @ExcelProperty(value = "入职时间")
    private LocalDate entryDate;

    /**
     * 工龄
     */
    @ExcelProperty(value = "工龄")
    private String yearsOfService;

    /**
     * 工龄总月数
     */
    @ExcelIgnore
    private Integer yearsOfServiceMonths;

    /**
     * 工龄段
     */
    @ExcelProperty(value = "工龄段", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_YEARS_SERVICE_SEGMENT)
    private String yearsOfServiceSegment;

    /**
     * 全日制学历
     */
    @ExcelProperty(value = "全日制学历")
    private String fulltimeEducation;

    /**
     * 全日制毕业院校
     */
    @ExcelProperty(value = "全日制毕业院校")
    private String fulltimeSchool;

    /**
     * 全日制专业
     */
    @ExcelProperty(value = "全日制专业")
    private String fulltimeMajor;

    /**
     * 全日制毕业日期
     */
    @ExcelProperty(value = "全日制毕业日期")
    private LocalDate fulltimeGraduationDate;

    /**
     * 全日制学位
     */
    @ExcelProperty(value = "全日制学位")
    private String fulltimeDegree;

    /**
     * 非全日制学历
     */
    @ExcelProperty(value = "非全日制学历")
    private String nonFulltimeEducation;

    /**
     * 非全日制毕业院校
     */
    @ExcelProperty(value = "非全日制毕业院校")
    private String nonFulltimeSchool;

    /**
     * 非全日制专业
     */
    @ExcelProperty(value = "非全日制专业")
    private String nonFulltimeMajor;

    /**
     * 非全日制毕业日期
     */
    @ExcelProperty(value = "非全日制毕业日期")
    private LocalDate nonFulltimeGraduationDate;

    /**
     * 非全日制学位
     */
    @ExcelProperty(value = "非全日制学位")
    private String nonFulltimeDegree;

    /**
     * 学历分类
     */
    @ExcelProperty(value = "学历分类", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_EDUCATION_CATEGORY)
    private String educationCategory;

    /**
     * 员工类型
     */
    @ExcelProperty(value = "员工类型", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_EMPLOYEE_TYPE)
    private String employeeType;

    /**
     * 职称情况
     */
    @ExcelProperty(value = "职称情况")
    private String professionalTitle;

    /**
     * 证书情况
     */
    @ExcelProperty(value = "证书情况")
    private String certificateStatus;

    /**
     * 外部个人履历
     */
    @ExcelProperty(value = "外部个人履历")
    private String externalResume;

    /**
     * 内部个人履历
     */
    @ExcelProperty(value = "内部个人履历")
    private String internalResume;

    /**
     * 用工形式
     */
    @ExcelProperty(value = "用工形式", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_EMPLOYMENT_FORM)
    private String employmentForm;

    /**
     * 合同形式
     */
    @ExcelProperty(value = "合同形式", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.HR_CONTRACT_FORM)
    private String contractForm;

    /**
     * 劳动合同期限
     */
    @ExcelProperty(value = "劳动合同期限")
    private String contractTerm;

    /**
     * 劳动合同开始时间
     */
    @ExcelProperty(value = "劳动合同开始时间")
    private LocalDate contractStartDate;

    /**
     * 劳动合同截止时间
     */
    @ExcelProperty(value = "劳动合同截止时间")
    private LocalDate contractEndDate;

    /**
     * 合同到期提醒
     * 自动计算，不用导入了
     */
    @ExcelIgnore
    private LocalDate contractExpirationReminder;

    /**
     * 劳动合同签订情况
     */
    @ExcelProperty(value = "劳动合同签订情况")
    private String contractSigningStatus;

    /**
     * 合同主体
     */
    @ExcelProperty(value = "合同主体")
    private String contractEntity;

    /**
     * 社保主体
     */
    @ExcelProperty(value = "社保主体")
    private String socialSecurityEntity;

    /**
     * 是否缴纳社保
     */
    @ExcelProperty(value = "是否缴纳社保", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.SYS_YES_NO)
    private String hasSocialSecurityPaid;

    /**
     * 公积金主体
     */
    @ExcelProperty(value = "公积金主体")
    private String providentFundEntity;

    /**
     * 是否缴纳公积金
     */
    @ExcelProperty(value = "是否缴纳公积金", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.SYS_YES_NO)
    private String hasProvidentFundPaid;

    /**
     * 试用期（月数）
     */
    @ExcelProperty(value = "试用期")
//    @ExcelDictFormat(readConverterExp = "月=数")
    private Integer probationPeriod;

    /**
     * 转正时间
     */
    @ExcelProperty(value = "转正时间")
    private LocalDate regularizationDate;

    /**
     * 奖励情况
     */
    @ExcelProperty(value = "奖励情况")
    private String rewardStatus;

    /**
     * 处罚情况
     */
    @ExcelProperty(value = "处罚情况")
    private String punishmentStatus;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remarks;

    /**
     * 办公电话
     */
    @ExcelProperty(value = "办公电话")
    private String officePhone;

    /**
     * 短线
     */
    @ExcelProperty(value = "短线")
    private String shortLine;

    /**
     * 银行卡号
     */
    @ExcelProperty(value = "银行卡号")
    private String bankCardNumber;

    /**
     * 开户行
     */
    @ExcelProperty(value = "开户行")
    private String bankName;

    /**
     * 公司内是否有亲属关系
     */
    @ExcelProperty(value = "公司内是否有亲属关系", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = HrConstant.SYS_YES_NO)
    private String hasRelativeInCompany;

    /**
     * 亲属姓名
     */
    @ExcelProperty(value = "亲属姓名")
    private String relativeName;

    /**
     * 介绍人
     */
    @ExcelProperty(value = "介绍人")
    private String introducer;

    /**
     * 工资发放地
     */
    @ExcelProperty(value = "工资发放地")
    private String salaryLocation;

    /**
     * 绩效比例
     */
    @ExcelProperty(value = "绩效比例")
    private String performanceRatio;


    public void setPlate(String plate) {
        this.plate = plate == null ? null : plate.trim();
    }

    public void setFirstLevelDepartment(String firstLevelDepartment) {
        this.firstLevelDepartment = firstLevelDepartment == null ? null : firstLevelDepartment.trim();
    }

    public void setSecondLevelDepartment(String secondLevelDepartment) {
        this.secondLevelDepartment = secondLevelDepartment == null ? null : secondLevelDepartment.trim();
    }

    public void setThirdLevelDepartment(String thirdLevelDepartment) {
        this.thirdLevelDepartment = thirdLevelDepartment == null ? null : thirdLevelDepartment.trim();
    }

    public void setEmployeeNo(String employeeNo) {
        this.employeeNo = employeeNo == null ? null : employeeNo.trim();
    }

    public void setPositionType(String positionType) {
        this.positionType = positionType == null ? null : positionType.trim();
    }

    public void setSequence(String sequence) {
        this.sequence = sequence == null ? null : sequence.trim();
    }

    public void setPosition(String position) {
        this.position = position == null ? null : position.trim();
    }

    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    public void setGender(String gender) {
        this.gender = gender == null ? null : gender.trim();
    }

    public void setIdCardNumber(String idCardNumber) {
        this.idCardNumber = idCardNumber == null ? null : idCardNumber.trim();
    }

    public void setPhoto(String photo) {
        this.photo = photo == null ? null : photo.trim();
    }

    public void setAgeGroup(String ageGroup) {
        this.ageGroup = ageGroup == null ? null : ageGroup.trim();
    }

    public void setPartTimePlate(String partTimePlate) {
        this.partTimePlate = partTimePlate == null ? null : partTimePlate.trim();
    }

    public void setPartTimeFirstDept(String partTimeFirstDept) {
        this.partTimeFirstDept = partTimeFirstDept == null ? null : partTimeFirstDept.trim();
    }

    public void setPartTimeSecondDept(String partTimeSecondDept) {
        this.partTimeSecondDept = partTimeSecondDept == null ? null : partTimeSecondDept.trim();
    }

    public void setPartTimeThirdDept(String partTimeThirdDept) {
        this.partTimeThirdDept = partTimeThirdDept == null ? null : partTimeThirdDept.trim();
    }

    public void setPartTimePosition(String partTimePosition) {
        this.partTimePosition = partTimePosition == null ? null : partTimePosition.trim();
    }

    public void setNativePlace(String nativePlace) {
        this.nativePlace = nativePlace == null ? null : nativePlace.trim();
    }

    public void setEthnicity(String ethnicity) {
        this.ethnicity = ethnicity == null ? null : ethnicity.trim();
    }

    public void setMaritalStatus(String maritalStatus) {
        this.maritalStatus = maritalStatus == null ? null : maritalStatus.trim();
    }

    public void setPoliticalStatus(String politicalStatus) {
        this.politicalStatus = politicalStatus == null ? null : politicalStatus.trim();
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber == null ? null : phoneNumber.trim();
    }

    public void setEmergencyContact(String emergencyContact) {
        this.emergencyContact = emergencyContact == null ? null : emergencyContact.trim();
    }

    public void setEmergencyContactPhone(String emergencyContactPhone) {
        this.emergencyContactPhone = emergencyContactPhone == null ? null : emergencyContactPhone.trim();
    }

    public void setHomeAddress(String homeAddress) {
        this.homeAddress = homeAddress == null ? null : homeAddress.trim();
    }

    public void setHouseholdRegistrationAddress(String householdRegistrationAddress) {
        this.householdRegistrationAddress = householdRegistrationAddress == null ? null : householdRegistrationAddress.trim();
    }

    public void setYearsOfService(String yearsOfService) {
        this.yearsOfService = yearsOfService == null ? null : yearsOfService.trim();
    }

    public void setYearsOfServiceSegment(String yearsOfServiceSegment) {
        this.yearsOfServiceSegment = yearsOfServiceSegment == null ? null : yearsOfServiceSegment.trim();
    }

    public void setFulltimeEducation(String fulltimeEducation) {
        this.fulltimeEducation = fulltimeEducation == null ? null : fulltimeEducation.trim();
    }

    public void setFulltimeSchool(String fulltimeSchool) {
        this.fulltimeSchool = fulltimeSchool == null ? null : fulltimeSchool.trim();
    }

    public void setFulltimeMajor(String fulltimeMajor) {
        this.fulltimeMajor = fulltimeMajor == null ? null : fulltimeMajor.trim();
    }

    public void setFulltimeDegree(String fulltimeDegree) {
        this.fulltimeDegree = fulltimeDegree == null ? null : fulltimeDegree.trim();
    }

    public void setNonFulltimeEducation(String nonFulltimeEducation) {
        this.nonFulltimeEducation = nonFulltimeEducation == null ? null : nonFulltimeEducation.trim();
    }

    public void setNonFulltimeSchool(String nonFulltimeSchool) {
        this.nonFulltimeSchool = nonFulltimeSchool == null ? null : nonFulltimeSchool.trim();
    }

    public void setNonFulltimeMajor(String nonFulltimeMajor) {
        this.nonFulltimeMajor = nonFulltimeMajor == null ? null : nonFulltimeMajor.trim();
    }

    public void setNonFulltimeDegree(String nonFulltimeDegree) {
        this.nonFulltimeDegree = nonFulltimeDegree == null ? null : nonFulltimeDegree.trim();
    }

    public void setEducationCategory(String educationCategory) {
        this.educationCategory = educationCategory == null ? null : educationCategory.trim();
    }

    public void setEmployeeType(String employeeType) {
        this.employeeType = employeeType == null ? null : employeeType.trim();
    }

    public void setProfessionalTitle(String professionalTitle) {
        this.professionalTitle = professionalTitle == null ? null : professionalTitle.trim();
    }

    public void setCertificateStatus(String certificateStatus) {
        this.certificateStatus = certificateStatus == null ? null : certificateStatus.trim();
    }

    public void setExternalResume(String externalResume) {
        this.externalResume = externalResume == null ? null : externalResume.trim();
    }

    public void setInternalResume(String internalResume) {
        this.internalResume = internalResume == null ? null : internalResume.trim();
    }

    public void setEmploymentForm(String employmentForm) {
        this.employmentForm = employmentForm == null ? null : employmentForm.trim();
    }

    public void setContractForm(String contractForm) {
        this.contractForm = contractForm == null ? null : contractForm.trim();
    }

    public void setContractTerm(String contractTerm) {
        this.contractTerm = contractTerm == null ? null : contractTerm.trim();
    }

    public void setContractSigningStatus(String contractSigningStatus) {
        this.contractSigningStatus = contractSigningStatus == null ? null : contractSigningStatus.trim();
    }

    public void setContractEntity(String contractEntity) {
        this.contractEntity = contractEntity == null ? null : contractEntity.trim();
    }

    public void setSocialSecurityEntity(String socialSecurityEntity) {
        this.socialSecurityEntity = socialSecurityEntity == null ? null : socialSecurityEntity.trim();
    }

    public void setHasSocialSecurityPaid(String hasSocialSecurityPaid) {
        this.hasSocialSecurityPaid = hasSocialSecurityPaid == null ? null : hasSocialSecurityPaid.trim();
    }

    public void setProvidentFundEntity(String providentFundEntity) {
        this.providentFundEntity = providentFundEntity == null ? null : providentFundEntity.trim();
    }

    public void setHasProvidentFundPaid(String hasProvidentFundPaid) {
        this.hasProvidentFundPaid = hasProvidentFundPaid == null ? null : hasProvidentFundPaid.trim();
    }

    public void setRewardStatus(String rewardStatus) {
        this.rewardStatus = rewardStatus == null ? null : rewardStatus.trim();
    }

    public void setPunishmentStatus(String punishmentStatus) {
        this.punishmentStatus = punishmentStatus == null ? null : punishmentStatus.trim();
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks == null ? null : remarks.trim();
    }

    public void setOfficePhone(String officePhone) {
        this.officePhone = officePhone == null ? null : officePhone.trim();
    }

    public void setShortLine(String shortLine) {
        this.shortLine = shortLine == null ? null : shortLine.trim();
    }

    public void setBankCardNumber(String bankCardNumber) {
        this.bankCardNumber = bankCardNumber == null ? null : bankCardNumber.trim();
    }

    public void setBankName(String bankName) {
        this.bankName = bankName == null ? null : bankName.trim();
    }

    public void setHasRelativeInCompany(String hasRelativeInCompany) {
        this.hasRelativeInCompany = hasRelativeInCompany == null ? null : hasRelativeInCompany.trim();
    }

    public void setRelativeName(String relativeName) {
        this.relativeName = relativeName == null ? null : relativeName.trim();
    }

    public void setIntroducer(String introducer) {
        this.introducer = introducer == null ? null : introducer.trim();
    }

    public void setSalaryLocation(String salaryLocation) {
        this.salaryLocation = salaryLocation == null ? null : salaryLocation.trim();
    }

    public void setPerformanceRatio(String performanceRatio) {
        this.performanceRatio = performanceRatio == null ? null : performanceRatio.trim();
    }
//
//    public void setDeptId(Long deptId) {
//        this.deptId = deptId;
//    }

    public void setJobLevel(Integer jobLevel) {
        this.jobLevel = jobLevel;
    }

    public void setBirthDate(LocalDate birthDate) {
        this.birthDate = birthDate;
    }

    public void setAge(Integer age) {
        this.age = age;
    }

    public void setWorkStartDate(LocalDate workStartDate) {
        this.workStartDate = workStartDate;
    }

    public void setEntryDate(LocalDate entryDate) {
        this.entryDate = entryDate;
    }

    public void setFulltimeGraduationDate(LocalDate fulltimeGraduationDate) {
        this.fulltimeGraduationDate = fulltimeGraduationDate;
    }

    public void setNonFulltimeGraduationDate(LocalDate nonFulltimeGraduationDate) {
        this.nonFulltimeGraduationDate = nonFulltimeGraduationDate;
    }

    public void setProbationPeriod(Integer probationPeriod) {
        this.probationPeriod = probationPeriod;
    }

    public void setRegularizationDate(LocalDate regularizationDate) {
        this.regularizationDate = regularizationDate;
    }

    public void setContractStartDate(LocalDate contractStartDate) {
        this.contractStartDate = contractStartDate;
    }

    public void setContractEndDate(LocalDate contractEndDate) {
        this.contractEndDate = contractEndDate;
    }

    public void setContractExpirationReminder(LocalDate contractExpirationReminder) {
        this.contractExpirationReminder = contractExpirationReminder;
    }

    public Integer getYearsOfServiceMonths() {
        return SeniorityUtils.parseSeniorityToMonths(this.yearsOfService);
    }

    public void setYearsOfServiceMonths(Integer yearsOfServiceMonths) {
        this.yearsOfServiceMonths = yearsOfServiceMonths;
    }
}
