package com.anplus.hr.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import com.alibaba.cola.dto.PageResponse;
import com.anplus.hr.domain.params.EmployeePhoneBookListParam;
import com.anplus.hr.domain.vo.EmployeePhoneBookVo;
import com.anplus.hr.service.EmployeePhoneBookServ;
import jakarta.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import top.binfast.common.core.constant.BusinessType;
import top.binfast.common.excel.annotion.ExcelExport;
import top.binfast.common.log.annotation.PinSysLog;

import java.util.List;

/**
 * 电话本管理
 *
 * @author LiuBin
 * @date 2025-11-19
 */
@Validated
@RestController
@RequestMapping("/employee/phoneBook")
public class EmployeePhoneBookCtrl {

    @Resource
    private EmployeePhoneBookServ employeePhoneBookServ;

    /**
     * 查询电话本管理列表
     */
    @SaCheckPermission("employee:phoneBook:list")
    @GetMapping("/page")
    public PageResponse<EmployeePhoneBookVo> pageList(EmployeePhoneBookListParam param) {
        return employeePhoneBookServ.queryPageList(param);
    }

    /**
     * 导出电话本管理列表
     */
    @ExcelExport(template = "电话本模板.xlsx", fill = true)
    @SaCheckPermission("employee:phoneBook:export")
    @PinSysLog(value = "电话本管理", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public List<EmployeePhoneBookVo> export(EmployeePhoneBookListParam param) {
        return employeePhoneBookServ.queryList(param);
    }

//    /**
//     * 获取电话本管理详细信息
//     *
//     * @param id 主键
//     */
//    @SaCheckPermission("hr:phoneBook:query")
//    @GetMapping("/{id}")
//    public SingleResponse<EmployeePhoneBookVo> getDetail(@PathVariable @Min(1)
//                                                    Long id) {
//        return SingleResponse.of(employeePhoneBookServ.queryById(id));
//    }

//    /**
//     * 新增电话本管理
//     */
//    @SaCheckPermission("hr:phoneBook:add")
//    @PinSysLog(value = "电话本管理", businessType = BusinessType.INSERT)
//    @PostMapping()
//    public Response add(@Validated(AddGroup.class) @RequestBody EmployeePhoneBookParam param) {
//        return ResponseUtils.ofResult(employeePhoneBookServ.insertByParam(param));
//    }
//
//    /**
//     * 修改电话本管理
//     */
//    @SaCheckPermission("hr:phoneBook:edit")
//    @PinSysLog(value = "电话本管理", businessType = BusinessType.UPDATE)
//    @PutMapping()
//    public Response edit(@Validated(EditGroup.class) @RequestBody EmployeePhoneBookParam param) {
//        return ResponseUtils.ofResult(employeePhoneBookServ.updateByParam(param));
//    }

//    /**
//     * 删除电话本管理
//     *
//     * @param ids 主键串
//     */
//    @SaCheckPermission("hr:phoneBook:remove")
//    @PinSysLog(value = "电话本管理", businessType = BusinessType.DELETE)
//    @DeleteMapping("/{ids}")
//    public Response remove(@NotEmpty(message = "主键不能为空")
//                           @PathVariable Long[] ids) {
//        return ResponseUtils.ofResult(employeePhoneBookServ.delByIds(List.of(ids)));
//    }
}