package com.anplus.hr.domain.params;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.time.LocalDate;

/**
 * @author 刘斌
 * @date 2025/10/31 17:07
 */
@Data
public class EmployeeTransferApplyParam {

    private Long id;

    /**
     * 员工id
     */
    @NotNull(message = "员工不能为空")
    private Long employeeId;

    /**
     * 板块
     */
    @NotBlank(message = "板块不能为空")
    private String plate;

    /**
     * 一级部门
     */
    @NotBlank(message = "一级部门不能为空")
    private String firstLevelDepartment;

    /**
     * 二级部门
     */
    @NotBlank(message = "二级部门不能为空")
    private String secondLevelDepartment;

    /**
     * 三级部门
     */
    @NotBlank(message = "三级部门不能为空")
    private String thirdLevelDepartment;

    /**
     * 部门id
     */
    @NotNull(message = "部门id不能为空")
    private Long deptId;

    /**
     * 调配时间
     */
    @NotNull(message = "调配时间不能为空")
    private LocalDate transferDate;

    /**
     * 绩效比例
     */
//    @NotNull(message = "绩效比例不能为空", groups = { AddGroup.class, EditGroup.class })
    private String performanceRatio;

    /**
     * 编制所在地
     */
    private String staffingLocation;

    /**
     * 成本费用所属(写部门)
     */
    private String costOfDept;

    /**
     * 成本费用细分
     */
    private String costType;

    /**
     * 内部个人履历
     */
//    @NotBlank(message = "内部个人履历不能为空", groups = { AddGroup.class, EditGroup.class })
    private String internalResume;

    private String remark;
}
