package com.anplus.hr.domain.vo;

import cn.idev.excel.annotation.ExcelIgnoreUnannotated;
import cn.idev.excel.annotation.ExcelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.lang.String;


/**
 * 在职人员情况分析视图对象 employee_status_analysis
 *
 * @author LiuBin
 * @date 2025-11-25
 */
@Data
@ExcelIgnoreUnannotated
//@AutoMapper(target = EmployeeStatusAnalysis.class)
public class EmployeeStatusAnalysisVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 公司
     */
    @ExcelProperty(value = "公司")
    private String plate;

    /**
     * 总人数
     */
    @ExcelProperty(value = "总人数")
    private Integer totalCount;

    /**
     * 男性人数
     */
    @ExcelProperty(value = "男性人数")
    private Integer maleCount;

    /**
     * 女性人数
     */
    @ExcelProperty(value = "女性人数")
    private Integer femaleCount;

    /**
     * 24岁以下人数
     */
    @ExcelProperty(value = "24岁以下人数")
    private Integer under24Count;

    /**
     * 25-34岁人数
     */
    @ExcelProperty(value = "25-34岁人数")
    private Integer age25To34Count;

    /**
     * 35-44岁人数
     */
    @ExcelProperty(value = "35-44岁人数")
    private Integer age35To44Count;

    /**
     * 45岁以上人数
     */
    @ExcelProperty(value = "45岁以上人数")
    private Integer over45Count;

    /**
     * 专科以下人数
     */
    @ExcelProperty(value = "专科以下人数")
    private Integer belowCollegeCount;

    /**
     * 专科人数
     */
    @ExcelProperty(value = "专科人数")
    private Integer juniorCollegeCount;

    /**
     * 本科人数
     */
    @ExcelProperty(value = "本科人数")
    private Integer bachelorCount;

    /**
     * 硕士人数
     */
    @ExcelProperty(value = "硕士人数")
    private Integer postgraduateCount;

    /**
     * 小于2年人数
     */
    @ExcelProperty(value = "小于2年人数")
    private Integer lessThan2YearsCount;

    /**
     * 2年到5年人数
     */
    @ExcelProperty(value = "2年到5年人数")
    private Integer years2To5Count;

    /**
     * 5年到10年人数
     */
    @ExcelProperty(value = "5年到10年人数")
    private Integer years5To10Count;

    /**
     * 10年以上人数
     */
    @ExcelProperty(value = "10年以上人数")
    private Integer over10YearsCount;

    /**
     * 男性占比
     */
    @ExcelProperty(value = "男性占比")
    private String maleRatio;

    /**
     * 女性占比
     */
    @ExcelProperty(value = "女性占比")
    private String femaleRatio;

    /**
     * 24岁以下占比
     */
    @ExcelProperty(value = "24岁以下占比")
    private String under24Ratio;

    /**
     * 25-34岁占比
     */
    @ExcelProperty(value = "25-34岁占比")
    private String age25To34Ratio;

    /**
     * 35-44岁占比
     */
    @ExcelProperty(value = "35-44岁占比")
    private String age35To44Ratio;

    /**
     * 45岁以上占比
     */
    @ExcelProperty(value = "45岁以上占比")
    private String over45Ratio;

    /**
     * 专科以下占比
     */
    @ExcelProperty(value = "专科以下占比")
    private String belowCollegeRatio;

    /**
     * 专科占比
     */
    @ExcelProperty(value = "专科占比")
    private String juniorCollegeRatio;

    /**
     * 本科占比
     */
    @ExcelProperty(value = "本科占比")
    private String bachelorRatio;

    /**
     * 硕士占比
     */
    @ExcelProperty(value = "硕士占比")
    private String postgraduateRatio;

    /**
     * 小于2年占比
     */
    @ExcelProperty(value = "小于2年占比")
    private String lessThan2YearsRatio;

    /**
     * 2年到5年占比
     */
    @ExcelProperty(value = "2年到5年占比")
    private String years2To5Ratio;

    /**
     * 5年到10年占比
     */
    @ExcelProperty(value = "5年到10年占比")
    private String years5To10Ratio;

    /**
     * 10年以上占比
     */
    @ExcelProperty(value = "10年以上占比")
    private String over10YearsRatio;

    public EmployeeStatusAnalysisVo(String plate) {
        this.plate = plate;
        this.totalCount = 0;
        this.maleCount = 0;
        this.femaleCount = 0;
        this.under24Count = 0;
        this.age25To34Count = 0;
        this.age35To44Count = 0;
        this.over45Count = 0;
        this.belowCollegeCount = 0;
        this.juniorCollegeCount = 0;
        this.bachelorCount = 0;
        this.postgraduateCount = 0;
        this.lessThan2YearsCount = 0;
        this.years2To5Count = 0;
        this.years5To10Count = 0;
        this.over10YearsCount = 0;
    }
}
