package com.anplus.hr.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.cola.dto.PageResponse;
import com.alibaba.cola.dto.Response;
import com.anplus.hr.domain.vo.EmployeeFlowVo;
import com.anplus.hr.domain.vo.EmployeeInfoResumeVo;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.IService;
import com.anplus.hr.domain.EmployeeInfo;
import com.anplus.hr.domain.params.*;
import com.anplus.hr.domain.vo.EmployeeInfoImportVo;
import com.anplus.hr.domain.vo.EmployeeInfoVo;
import org.springframework.web.multipart.MultipartFile;
import top.binfast.app.biz.sysapi.bean.model.oss.SysOss;
import top.binfast.app.biz.sysapi.bean.vo.sysOss.SysOssVo;
import top.binfast.common.excel.image.CellImageData;
import top.binfast.common.excel.image.ExcelProcessingResult;
import top.binfast.common.oss.entity.UploadResult;

import java.util.List;
import java.util.stream.Stream;

/**
 * 员工信息Service接口
 *
 * @author LiuBin
 * @date 2025-10-28
 */
public interface EmployeeInfoServ extends IService<EmployeeInfo> {


    /**
     * 分页查询员工信息列表
     *
     * @param param        查询条件
     * @return 员工信息分页列表
     */
    PageResponse<EmployeeInfoVo> queryPageList(EmployeeInfoListParam param);

    /**
     * 查询符合条件的员工信息列表
     *
     * @param param 查询条件
     * @return 员工信息列表
     */
    List<EmployeeInfoVo> queryList(EmployeeInfoListParam param);

    /**
     * 构建查询条件
     *
     * @param param 查询条件
     * @return 查询条件
     */
    LambdaQueryWrapper<EmployeeInfo> buildQueryWrapper(EmployeeInfoListParam param);

    /**
     * 导入员工信息列表
     *
     * @param stream 员工信息列表
     * @return 是否导入成功
     */
    Response importEmployeeList(Stream<EmployeeInfoImportVo> stream, MultipartFile file);

    /**
     * 校验员工名称是否唯一
     *
     * @param param 员工信息
     * @return 是否唯一
     */
    Boolean checkEmployeeIdCardNumberUnique(EmployeeInfoParam param);
    /**
     * 查询员工信息
     *
     * @param id 主键
     * @return 员工信息
     */
     EmployeeInfoVo queryById(Long id);

     /**
     * 员工信息详情
     *
     * @param id 主键
     * @return 员工信息
     */
     EmployeeInfoVo infoDetail(Long id);

     /**
     * 导出简历用：员工信息详情
     *
     * @param id 主键
     * @return 员工信息
     */
    EmployeeInfoResumeVo infoDetailForResume(Long id);

    /**
     * 新增员工信息
     *
     * @param param 员工信息
     * @return 是否新增成功
     */
    Boolean insertByParam(EmployeeInfoParam param);

    /**
     * 新增基础员工信息
     *
     * @param param 员工信息
     * @return 是否新增成功
     */
    Boolean insertBaseInfoForH5(EmployeeBaseInfoParam param);

    /**
     * 修改员工信息
     *
     * @param param 员工信息
     * @return 是否修改成功
     */
    Boolean updateByParam(EmployeeInfoParam param);

    /**
     * 员工入职申请
     *
     * @param param 参数
     */
    EmployeeFlowVo applyEntry(EmployeeEntryApplyParam param);

    /**
     * 员工调职申请
     *
     * @param param 参数
     */
    EmployeeFlowVo applyTransfer(EmployeeTransferApplyParam param);

    /**
     * 员工离职申请
     *
     * @param param 参数
     */
    EmployeeFlowVo applyResign(EmployeeResignApplyParam param);

    /**
     * 员工转正申请
     *
     * @param param 参数
     */
    EmployeeFlowVo applyRegular(EmployeeRegularApplyParam param);

    /**
     * 员工续签合同申请
     *
     * @param param 参数
     */
    EmployeeFlowVo applyRenewalContract(EmployeeRenewalContractApplyParam param);

    /**
     * 校验并批量删除员工信息信息
     *
     * @param ids     待删除的主键集合
     * @return 是否删除成功
     */
    Boolean delByIds(List<Long> ids);

    /**
     * 处理图片上传结果
     *
     * @param excelProcessingResult excel处理结果
     * @param importVo              导入数据
     */
    SysOss handleImageToUrl(ExcelProcessingResult excelProcessingResult, EmployeeInfoImportVo importVo);

    /**
     * 上传 MultipartFile 到对象存储服务，并保存文件信息到数据库
     *
     * @param file 要上传的 MultipartFile 对象
     * @return 上传成功后的 SysOssVo 对象，包含文件信息
     */
    SysOssVo upload(MultipartFile file);

    /**
     * 构建部门名称字符串
     *
     * @param importVo 导入数据
     * @return 部门名称字符串
     */
    default String buildDeptNameStr(EmployeeInfoImportVo importVo) {
        StringBuilder builder = new StringBuilder(importVo.getPlate());
        if (StrUtil.isNotBlank(importVo.getFirstLevelDepartment())) {
            builder.append(StrUtil.SLASH).append(importVo.getFirstLevelDepartment());
        }
        if (StrUtil.isNotBlank(importVo.getSecondLevelDepartment())) {
            builder.append(StrUtil.SLASH).append(importVo.getSecondLevelDepartment());
        }
        if (StrUtil.isNotBlank(importVo.getThirdLevelDepartment())) {
            builder.append(StrUtil.SLASH).append(importVo.getThirdLevelDepartment());
        }
        return builder.toString();
    }

    default String buildPartDeptNameStr(EmployeeInfoImportVo importVo) {
        StringBuilder builder = new StringBuilder(importVo.getConcurrentPlate());
        if (StrUtil.isNotBlank(importVo.getConcurrentFirstDept())) {
            builder.append(StrUtil.SLASH).append(importVo.getConcurrentFirstDept());
        }
        if (StrUtil.isNotBlank(importVo.getConcurrentSecondDept())) {
            builder.append(StrUtil.SLASH).append(importVo.getConcurrentSecondDept());
        }
        if (StrUtil.isNotBlank(importVo.getConcurrentThirdDept())) {
            builder.append(StrUtil.SLASH).append(importVo.getConcurrentThirdDept());
        }
        return builder.toString();
    }

}
