package com.anplus.hr.service;

import com.alibaba.cola.dto.PageResponse;
import com.alibaba.cola.dto.Response;
import com.anplus.hr.domain.EmployeeInfo;
import com.anplus.hr.domain.params.EmployeeInfoListParam;
import com.anplus.hr.domain.vo.EmployeeInfoResignImportVo;
import com.anplus.hr.domain.vo.EmployeeInfoResignVo;
import com.baomidou.mybatisplus.extension.service.IService;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.stream.Stream;

/**
 * @author 刘斌
 * @date 2025/11/13 20:40
 */
public interface EmployeeInfoResignServ extends IService<EmployeeInfo> {

    /**
     * 分页查询离职员工信息列表
     *
     * @param param        查询条件
     * @return 员工信息分页列表
     */
    PageResponse<EmployeeInfoResignVo> queryPageList(EmployeeInfoListParam param);

    /**
     * 查询符合条件的离职员工信息列表
     *
     * @param param 查询条件
     * @return 员工信息列表
     */
    List<EmployeeInfoResignVo> queryList(EmployeeInfoListParam param);

    /**
     * 导入离职员工信息列表
     *
     * @param stream 员工信息列表
     * @return 是否导入成功
     */
    Response importEmployeeResignList(Stream<EmployeeInfoResignImportVo> stream, MultipartFile file);

    /**
     * 获取离职员工信息详情
     *
     * @param id 主键
     * @return 员工信息
     */
    EmployeeInfoResignVo infoDetail(Long id);


}
