package com.anplus.hr.domain.params;

import com.anplus.hr.domain.EmployeeDept;
import io.github.linpeilie.annotations.AutoMapper;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Data;
import top.binfast.common.core.validate.AddGroup;
import top.binfast.common.core.validate.EditGroup;

/**
 * 员工部门业务对象 employee_dept
 *
 * @author LiuBin
 * @date 2025-10-30
 */
@Data
@AutoMapper(target = EmployeeDept.class, reverseConvertGenerate = false)
public class EmployeeDeptParam {

    /**
     * 主键
     */
    @NotNull(message = "主键不能为空", groups = { EditGroup.class })
    private Long id;

    /**
     * 父级部门
     */
    @NotNull(message = "父级部门不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long parentId;

    /**
     * 父级部门名称
     */
    private String parentName;

    /**
     * 部门名称
     */
    @NotBlank(message = "部门名称不能为空", groups = { AddGroup.class, EditGroup.class })
    private String name;

    /**
     * 部门层级
     */
    private Integer level;

    /**
     * 祖级关系
     */
    @NotBlank(message = "祖级关系不能为空", groups = { AddGroup.class, EditGroup.class })
    private String nodePath;

    /**
     * 显示顺序
     */
    @NotNull(message = "显示顺序不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long orderNum;

    /**
     * 状态
     */
    @NotNull(message = "状态不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer status;


}
