package com.anplus.hr.service.impl;

import com.anplus.hr.domain.EmployeeInfo;
import com.anplus.hr.domain.params.EmployeeStatusAnalysisListParam;
import com.anplus.hr.domain.vo.EmployeeStatusAnalysisVo;
import com.anplus.hr.mapper.EmployeeInfoMapper;
import com.anplus.hr.service.EmployeeStatusAnalysisServ;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.RequiredArgsConstructor;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

/**
 * 在职人员情况分析Service业务层处理
 *
 * @author LiuBin
 * @date 2025-11-25
 */
@RequiredArgsConstructor
@Service
public class EmployeeStatusAnalysisServImpl extends ServiceImpl<EmployeeInfoMapper, EmployeeInfo> implements EmployeeStatusAnalysisServ {

    private final EmployeeInfoMapper employeeInfoMapper;

//    /**
//     * 分页查询在职人员情况分析列表
//     *
//     * @param param 查询条件
//     * @return 在职人员情况分析分页列表
//     */
//    @Override
//    public PageResponse<EmployeeStatusAnalysisVo> queryPageList(EmployeeStatusAnalysisListParam param) {
//        Page<EmployeeInfo> page = QueryUtil.getPage(param);
//        LambdaQueryWrapper<EmployeeInfo> lambdaQuery = this.buildQueryWrapper(param);
//        employeeInfoMapper.selectPage(page, lambdaQuery);
//        return QueryUtil.getPageResponse(page, MapstructUtils.convert(page.getRecords(), EmployeeStatusAnalysisVo.class));
//    }


    /**
     * 查询符合条件的在职人员情况分析列表
     *
     * @param param 查询条件
     * @return 在职人员情况分析列表
     */
    @Override
    public List<EmployeeStatusAnalysisVo> queryList(EmployeeStatusAnalysisListParam param) {
//        LambdaQueryWrapper<EmployeeInfo> lambdaQuery = this.buildQueryWrapper(param);
        List<EmployeeStatusAnalysisVo> statusAnalysisVos = employeeInfoMapper.queryStatusAnalysisList();
        if (!statusAnalysisVos.isEmpty()) {
            EmployeeStatusAnalysisVo sumVo = getStatusAnalysisSumVo(statusAnalysisVos);
            statusAnalysisVos.add(sumVo);
            for (EmployeeStatusAnalysisVo statusAnalysisVo : statusAnalysisVos) {
                statusAnalysisVo.setMaleRatio(calcRatio(statusAnalysisVo.getMaleCount(), statusAnalysisVo.getTotalCount()));
                statusAnalysisVo.setFemaleRatio(calcRatio(statusAnalysisVo.getFemaleCount(), statusAnalysisVo.getTotalCount()));
                statusAnalysisVo.setUnder24Ratio(calcRatio(statusAnalysisVo.getUnder24Count(), statusAnalysisVo.getTotalCount()));
                statusAnalysisVo.setAge25To34Ratio(calcRatio(statusAnalysisVo.getAge25To34Count(), statusAnalysisVo.getTotalCount()));
                statusAnalysisVo.setAge35To44Ratio(calcRatio(statusAnalysisVo.getAge35To44Count(), statusAnalysisVo.getTotalCount()));
                statusAnalysisVo.setOver45Ratio(calcRatio(statusAnalysisVo.getOver45Count(), statusAnalysisVo.getTotalCount()));
                statusAnalysisVo.setBelowCollegeRatio(calcRatio(statusAnalysisVo.getBelowCollegeCount(), statusAnalysisVo.getTotalCount()));
                statusAnalysisVo.setJuniorCollegeRatio(calcRatio(statusAnalysisVo.getJuniorCollegeCount(), statusAnalysisVo.getTotalCount()));
                statusAnalysisVo.setBachelorRatio(calcRatio(statusAnalysisVo.getBachelorCount(), statusAnalysisVo.getTotalCount()));
                statusAnalysisVo.setPostgraduateRatio(calcRatio(statusAnalysisVo.getPostgraduateCount(), statusAnalysisVo.getTotalCount()));
                statusAnalysisVo.setLessThan2YearsRatio(calcRatio(statusAnalysisVo.getLessThan2YearsCount(), statusAnalysisVo.getTotalCount()));
                statusAnalysisVo.setYears2To5Ratio(calcRatio(statusAnalysisVo.getYears2To5Count(), statusAnalysisVo.getTotalCount()));
                statusAnalysisVo.setYears5To10Ratio(calcRatio(statusAnalysisVo.getYears5To10Count(), statusAnalysisVo.getTotalCount()));
                statusAnalysisVo.setOver10YearsRatio(calcRatio(statusAnalysisVo.getOver10YearsCount(), statusAnalysisVo.getTotalCount()));
            }
        }
        return statusAnalysisVos;
    }

    @NotNull
    private static EmployeeStatusAnalysisVo getStatusAnalysisSumVo(List<EmployeeStatusAnalysisVo> statusAnalysisVos) {
        EmployeeStatusAnalysisVo sumVo = new EmployeeStatusAnalysisVo("合计");
        for (EmployeeStatusAnalysisVo statusAnalysisVo : statusAnalysisVos) {
            sumVo.setTotalCount(sumVo.getTotalCount() + statusAnalysisVo.getTotalCount());
            sumVo.setMaleCount(sumVo.getMaleCount() + statusAnalysisVo.getMaleCount());
            sumVo.setFemaleCount(sumVo.getFemaleCount() + statusAnalysisVo.getFemaleCount());
            sumVo.setUnder24Count(sumVo.getUnder24Count() + statusAnalysisVo.getUnder24Count());
            sumVo.setAge25To34Count(sumVo.getAge25To34Count() + statusAnalysisVo.getAge25To34Count());
            sumVo.setAge35To44Count(sumVo.getAge35To44Count() + statusAnalysisVo.getAge35To44Count());
            sumVo.setOver45Count(sumVo.getOver45Count() + statusAnalysisVo.getOver45Count());
            sumVo.setBelowCollegeCount(sumVo.getBelowCollegeCount() + statusAnalysisVo.getBelowCollegeCount());
            sumVo.setJuniorCollegeCount(sumVo.getJuniorCollegeCount() + statusAnalysisVo.getJuniorCollegeCount());
            sumVo.setBachelorCount(sumVo.getBachelorCount() + statusAnalysisVo.getBachelorCount());
            sumVo.setPostgraduateCount(sumVo.getPostgraduateCount() + statusAnalysisVo.getPostgraduateCount());
            sumVo.setLessThan2YearsCount(sumVo.getLessThan2YearsCount() + statusAnalysisVo.getLessThan2YearsCount());
            sumVo.setYears2To5Count(sumVo.getYears2To5Count() + statusAnalysisVo.getYears2To5Count());
            sumVo.setYears5To10Count(sumVo.getYears5To10Count() + statusAnalysisVo.getYears5To10Count());
            sumVo.setOver10YearsCount(sumVo.getOver10YearsCount() + statusAnalysisVo.getOver10YearsCount());
        }
        return sumVo;
    }

    private String calcRatio(Integer count, Integer total) {
        if (count == null || count == 0 || total == null || total == 0) {
            return "0.00%";
        }
        String rate = new BigDecimal(count).divide(new BigDecimal(total), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP).toString();
        return rate + "%";
    }

//    private LambdaQueryWrapper<EmployeeInfo> buildQueryWrapper(EmployeeStatusAnalysisListParam param) {
//        LambdaQueryWrapper<EmployeeInfo> lambdaQuery = Wrappers.<EmployeeInfo>lambdaQuery();
//        lambdaQuery.orderByDesc(EmployeeInfo::getId);
//        lambdaQuery.eq(param.getTotalCount() != null, EmployeeInfo::getTotalCount, param.getTotalCount());
//        lambdaQuery.eq(param.getMaleCount() != null, EmployeeInfo::getMaleCount, param.getMaleCount());
//        lambdaQuery.eq(param.getFemaleCount() != null, EmployeeInfo::getFemaleCount, param.getFemaleCount());
//        lambdaQuery.eq(param.getUnder24Count() != null, EmployeeInfo::getUnder24Count, param.getUnder24Count());
//        lambdaQuery.eq(param.getAge25To34Count() != null, EmployeeInfo::getAge25To34Count, param.getAge25To34Count());
//        lambdaQuery.eq(param.getAge35To44Count() != null, EmployeeInfo::getAge35To44Count, param.getAge35To44Count());
//        lambdaQuery.eq(param.getOver45Count() != null, EmployeeInfo::getOver45Count, param.getOver45Count());
//        lambdaQuery.eq(param.getBelowCollegeCount() != null, EmployeeInfo::getBelowCollegeCount, param.getBelowCollegeCount());
//        lambdaQuery.eq(param.getCollegeCount() != null, EmployeeInfo::getCollegeCount, param.getCollegeCount());
//        lambdaQuery.eq(param.getBachelorCount() != null, EmployeeInfo::getBachelorCount, param.getBachelorCount());
//        lambdaQuery.eq(param.getMasterCount() != null, EmployeeInfo::getMasterCount, param.getMasterCount());
//        lambdaQuery.eq(param.getLessThan2YearsCount() != null, EmployeeInfo::getLessThan2YearsCount, param.getLessThan2YearsCount());
//        lambdaQuery.eq(param.getYears2To5Count() != null, EmployeeInfo::getYears2To5Count, param.getYears2To5Count());
//        lambdaQuery.eq(param.getYears5To10Count() != null, EmployeeInfo::getYears5To10Count, param.getYears5To10Count());
//        lambdaQuery.eq(param.getOver10YearsCount() != null, EmployeeInfo::getOver10YearsCount, param.getOver10YearsCount());
//        lambdaQuery.eq(param.getMaleRatio() != null, EmployeeInfo::getMaleRatio, param.getMaleRatio());
//        lambdaQuery.eq(param.getFemaleRatio() != null, EmployeeInfo::getFemaleRatio, param.getFemaleRatio());
//        lambdaQuery.eq(param.getUnder24Ratio() != null, EmployeeInfo::getUnder24Ratio, param.getUnder24Ratio());
//        lambdaQuery.eq(param.getAge25To34Ratio() != null, EmployeeInfo::getAge25To34Ratio, param.getAge25To34Ratio());
//        lambdaQuery.eq(param.getAge35To44Ratio() != null, EmployeeInfo::getAge35To44Ratio, param.getAge35To44Ratio());
//        lambdaQuery.eq(param.getOver45Ratio() != null, EmployeeInfo::getOver45Ratio, param.getOver45Ratio());
//        lambdaQuery.eq(param.getBelowCollegeRatio() != null, EmployeeInfo::getBelowCollegeRatio, param.getBelowCollegeRatio());
//        lambdaQuery.eq(param.getCollegeRatio() != null, EmployeeInfo::getCollegeRatio, param.getCollegeRatio());
//        lambdaQuery.eq(param.getBachelorRatio() != null, EmployeeInfo::getBachelorRatio, param.getBachelorRatio());
//        lambdaQuery.eq(param.getMasterRatio() != null, EmployeeInfo::getMasterRatio, param.getMasterRatio());
//        lambdaQuery.eq(param.getLessThan2YearsRatio() != null, EmployeeInfo::getLessThan2YearsRatio, param.getLessThan2YearsRatio());
//        lambdaQuery.eq(param.getYears2To5Ratio() != null, EmployeeInfo::getYears2To5Ratio, param.getYears2To5Ratio());
//        lambdaQuery.eq(param.getYears5To10Ratio() != null, EmployeeInfo::getYears5To10Ratio, param.getYears5To10Ratio());
//        lambdaQuery.eq(param.getOver10YearsRatio() != null, EmployeeInfo::getOver10YearsRatio, param.getOver10YearsRatio());
//        return lambdaQuery;
//    }

//    /**
//     * 查询在职人员情况分析
//     *
//     * @param id 主键
//     * @return 在职人员情况分析
//     */
//    @Override
//    public EmployeeStatusAnalysisVo queryById(Long id){
//        EmployeeInfo employeeStatusAnalysis = employeeInfoMapper.selectById(id);
//        return MapstructUtils.convert(employeeStatusAnalysis, EmployeeStatusAnalysisVo.class);
//    }
//
//    /**
//     * 新增在职人员情况分析
//     *
//     * @param param 在职人员情况分析
//     * @return 是否新增成功
//     */
//    @Override
//    public Boolean insertByParam(EmployeeStatusAnalysisParam param) {
//        EmployeeInfo employeeStatusAnalysis = MapstructUtils.convert(param, EmployeeInfo.class);
//        return this.save(employeeStatusAnalysis);
//    }
//
//    /**
//     * 修改在职人员情况分析
//     *
//     * @param param 在职人员情况分析
//     * @return 是否修改成功
//     */
//    @Override
//    public Boolean updateByParam(EmployeeStatusAnalysisParam param) {
//        EmployeeInfo employeeStatusAnalysis = MapstructUtils.convert(param, EmployeeInfo.class);
//        return this.updateById(employeeStatusAnalysis);
//    }
//
//    /**
//     * 保存前的数据校验
//     */
//    private void validEntityBeforeSave(EmployeeInfo entity){
//        // 做一些数据校验,如唯一约束
//    }
//
//    /**
//     * 校验并批量删除在职人员情况分析信息
//     *
//     * @param ids 待删除的主键集合
//     * @return 是否删除成功
//     */
//    @Override
//    @Transactional(rollbackFor = {Exception.class})
//    public Boolean delByIds(List<Long> ids) {
//        //做一些业务上的校验,判断是否需要校验
//        return this.removeByIds(ids);
//    }
}
