package com.anplus.hr.domain.params;

import com.anplus.hr.domain.EmployeeChangeLog;
import io.github.linpeilie.annotations.AutoMapper;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Data;
import top.binfast.common.core.validate.AddGroup;
import top.binfast.common.core.validate.EditGroup;

import java.time.LocalDate;

;

/**
 * 员工变动记录业务对象 employee_change_log
 *
 * @author LiuBin
 * @date 2025-11-24
 */
@Data
@AutoMapper(target = EmployeeChangeLog.class, reverseConvertGenerate = false)
public class EmployeeChangeLogParam {

    /**
     * 主键
     */
    @NotNull(message = "主键不能为空", groups = { EditGroup.class })
    private Long id;

    /**
     * 变动类型
     */
    @NotBlank(message = "变动类型不能为空", groups = { AddGroup.class, EditGroup.class })
    private String type;

    /**
     * 流程申请编号
     */
    @NotBlank(message = "流程申请编号不能为空", groups = { AddGroup.class, EditGroup.class })
    private String applyCode;

    /**
     * 板块ID
     */
    @NotNull(message = "板块ID不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long plateId;

    /**
     * 板块
     */
    @NotBlank(message = "板块不能为空", groups = { AddGroup.class, EditGroup.class })
    private String plate;

    /**
     * 部门ID
     */
    @NotNull(message = "部门ID不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long deptId;

    /**
     * 员工ID
     */
    @NotNull(message = "员工ID不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long employeeId;

    /**
     * 变动时间
     */
    @NotNull(message = "变动时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate changeDate;

    /**
     * 离职类型
     */
    @NotBlank(message = "离职类型不能为空", groups = { AddGroup.class, EditGroup.class })
    private String resignType;

    /**
     * 离职工龄类型
     */
    @NotBlank(message = "离职工龄类型不能为空", groups = { AddGroup.class, EditGroup.class })
    private String resignYearsOfServiceType;


}
