package com.anplus.hr.domain.params;

import lombok.Getter;
import lombok.Setter;
import top.binfast.common.core.bean.params.PageQueryParam;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;

/**
 * 员工合同续签提醒分页对象 employee_contract_expiration_reminder
 *
 * @author LiuBin
 * @date 2025-11-20
 */
@Getter
@Setter
public class ContractExpirationReminderListParam extends PageQueryParam {

    /**
     * 板块
     */
    private String plate;

    /**
     * 一级部门
     */
    private String firstLevelDepartment;

    /**
     * 二级部门
     */
    private String secondLevelDepartment;

    /**
     * 三级部门
     */
    private String thirdLevelDepartment;

    /**
     * 部门ID
     */
    private Long deptId;

    /**
     * 主岗位
     */
    private String position;

    /**
     * 姓名
     */
    private String name;

    /**
     * 手机号码
     */
    private String phoneNumber;

    /**
     * 劳动合同开始时间
     */
    private LocalDate contractStartDate;

    /**
     * 劳动合同截止时间
     */
    private LocalDate contractEndDate;

    /**
     * 合同形式
     */
    private String contractForm;

    /**
     * 备注
     */
    private String remarks;

    /**
     * 归属部门id（部门树）
     */
    private Long belongDeptId;


    private Map<String, Object> params = new HashMap<>();

}
