package com.anplus.hr.domain.params;

import com.anplus.hr.domain.EmployeeInfo;
import io.github.linpeilie.annotations.AutoMapper;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.time.LocalDate;
import java.util.List;

/**
 * @author 刘斌
 * @date 2025/11/25 20:56
 */
@Data
@AutoMapper(target = EmployeeInfo.class, reverseConvertGenerate = false)
public class EmployeeBaseInfoParam {

    /**
     * 姓名
     */
    @NotBlank(message = "姓名不能为空")
    private String name;

    /**
     * 手机号码
     */
    @NotBlank(message = "手机号码不能为空")
    private String phoneNumber;

    /**
     * 性别
     */
    @NotBlank(message = "性别不能为空")
    private String gender;

    /**
     * 身份证号码
     */
    @NotBlank(message = "身份证号码不能为空")
    private String idCardNumber;

    /**
     * 出生日期
     */
    @NotNull(message = "出生日期不能为空")
    private LocalDate birthDate;

    /**
     * 年龄
     */
    @NotNull(message = "年龄不能为空")
    private Integer age;

//    /**
//     * 照片
//     */
//    @NotBlank(message = "照片不能为空")
//    private String photo;

    /**
     * 头像OSS_ID
     */
    private Long ossId;

    /**
     * 籍贯
     */
    @NotBlank(message = "籍贯不能为空")
    private String nativePlace;

    /**
     * 民族
     */
    @NotBlank(message = "民族不能为空")
    private String ethnicity;

    /**
     * 婚姻状况
     */
    @NotBlank(message = "婚姻状况不能为空")
    private String maritalStatus;

    /**
     * 政治面貌
     */
    @NotBlank(message = "政治面貌不能为空")
    private String politicalStatus;

//    /**
//     * 紧急联系人
//     */
//    @NotBlank(message = "紧急联系人不能为空")
//    private String emergencyContact;
//
//    /**
//     * 紧急联系人电话
//     */
//    @NotBlank(message = "紧急联系人电话不能为空")
//    private String emergencyContactPhone;

    /**
     * 家庭地址
     */
    @NotBlank(message = "家庭地址不能为空")
    private String homeAddress;

    /**
     * 户口所在地
     */
    @NotBlank(message = "户口所在地不能为空")
    private String householdRegistrationAddress;

    /**
     * 参加工作时间
     */
//    @NotNull(message = "参加工作时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate workStartDate;

    /**
     * 职称情况
     */
//    @NotBlank(message = "职称情况不能为空", groups = { AddGroup.class, EditGroup.class })
    private String professionalTitle;

    /**
     * 证书情况
     */
//    @NotBlank(message = "证书情况不能为空", groups = { AddGroup.class, EditGroup.class })
    private String certificateStatus;

    /**
     * 全日制学历
     */
//    @NotBlank(message = "全日制学历不能为空", groups = { AddGroup.class, EditGroup.class })
    private String fulltimeEducation;

    /**
     * 全日制毕业院校
     */
//    @NotBlank(message = "全日制毕业院校不能为空", groups = { AddGroup.class, EditGroup.class })
    private String fulltimeSchool;

    /**
     * 全日制专业
     */
//    @NotBlank(message = "全日制专业不能为空", groups = { AddGroup.class, EditGroup.class })
    private String fulltimeMajor;

    /**
     * 全日制毕业日期
     */
//    @NotNull(message = "全日制毕业日期不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate fulltimeGraduationDate;

    /**
     * 全日制学位
     */
//    @NotBlank(message = "全日制学位不能为空", groups = { AddGroup.class, EditGroup.class })
    private String fulltimeDegree;

    /**
     * 非全日制学历
     */
//    @NotBlank(message = "非全日制学历不能为空", groups = { AddGroup.class, EditGroup.class })
    private String nonFulltimeEducation;

    /**
     * 非全日制毕业院校
     */
//    @NotBlank(message = "非全日制毕业院校不能为空", groups = { AddGroup.class, EditGroup.class })
    private String nonFulltimeSchool;

    /**
     * 非全日制专业
     */
//    @NotBlank(message = "非全日制专业不能为空", groups = { AddGroup.class, EditGroup.class })
    private String nonFulltimeMajor;

    /**
     * 非全日制毕业日期
     */
//    @NotNull(message = "非全日制毕业日期不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate nonFulltimeGraduationDate;

    /**
     * 非全日制学位
     */
//    @NotBlank(message = "非全日制学位不能为空", groups = { AddGroup.class, EditGroup.class })
    private String nonFulltimeDegree;

    /**
     * 外部个人履历
     */
//    @NotBlank(message = "外部个人履历不能为空", groups = { AddGroup.class, EditGroup.class })
    private String externalResume;

    /**
     * 家庭成员
     */
    private List<EmployeeFamilyMembersParam> employeeFamilyMembers;

    /**
     * tid
     */
    @NotBlank(message = "tid不能为空")
    private Long tenantId;
}
