package com.anplus.hr.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import com.alibaba.cola.dto.MultiResponse;
import com.anplus.hr.domain.params.EmployeeStatusAnalysisListParam;
import com.anplus.hr.domain.vo.EmployeeStatusAnalysisVo;
import com.anplus.hr.service.EmployeeStatusAnalysisServ;
import jakarta.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import top.binfast.common.core.constant.BusinessType;
import top.binfast.common.excel.annotion.ExcelExport;
import top.binfast.common.log.annotation.PinSysLog;

import java.util.List;

/**
 * 在职人员情况分析
 *
 * @author LiuBin
 * @date 2025-11-25
 */
//@Validated
@RestController
@RequestMapping("/employee/statusAnalysis")
public class EmployeeStatusAnalysisCtrl {

    @Resource
    private EmployeeStatusAnalysisServ employeeStatusAnalysisServ;

    /**
     * 查询在职人员情况分析列表
     */
    @SaCheckPermission("employee:statusAnalysis:list")
    @GetMapping("/page")
    public MultiResponse<EmployeeStatusAnalysisVo> pageList(EmployeeStatusAnalysisListParam param) {
        return MultiResponse.of(employeeStatusAnalysisServ.queryList(param));
    }

    /**
     * 导出在职人员情况分析列表
     */
    @ExcelExport(template = "在职人员分析模板.xlsx", fill = true)
    @SaCheckPermission("employee:statusAnalysis:export")
    @PinSysLog(value = "在职人员情况分析", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public List<EmployeeStatusAnalysisVo> export(EmployeeStatusAnalysisListParam param) {
        return employeeStatusAnalysisServ.queryList(param);
    }

//    /**
//     * 获取在职人员情况分析详细信息
//     *
//     * @param id 主键
//     */
//    @SaCheckPermission("employee:employeeStatusAnalysis:query")
//    @GetMapping("/{id}")
//    public SingleResponse<EmployeeStatusAnalysisVo> getDetail(@PathVariable @Min(1)
//                                                    Long id) {
//        return SingleResponse.of(employeeStatusAnalysisServ.queryById(id));
//    }
//
//    /**
//     * 新增在职人员情况分析
//     */
//    @SaCheckPermission("employee:employeeStatusAnalysis:add")
//    @PinSysLog(value = "在职人员情况分析", businessType = BusinessType.INSERT)
//    @PostMapping()
//    public Response add(@Validated(AddGroup.class) @RequestBody EmployeeStatusAnalysisParam param) {
//        return ResponseUtils.ofResult(employeeStatusAnalysisServ.insertByParam(param));
//    }
//
//    /**
//     * 修改在职人员情况分析
//     */
//    @SaCheckPermission("employee:employeeStatusAnalysis:edit")
//    @PinSysLog(value = "在职人员情况分析", businessType = BusinessType.UPDATE)
//    @PutMapping()
//    public Response edit(@Validated(EditGroup.class) @RequestBody EmployeeStatusAnalysisParam param) {
//        return ResponseUtils.ofResult(employeeStatusAnalysisServ.updateByParam(param));
//    }
//
//    /**
//     * 删除在职人员情况分析
//     *
//     * @param ids 主键串
//     */
//    @SaCheckPermission("employee:employeeStatusAnalysis:remove")
//    @PinSysLog(value = "在职人员情况分析", businessType = BusinessType.DELETE)
//    @DeleteMapping("/{ids}")
//    public Response remove(@NotEmpty(message = "主键不能为空")
//                           @PathVariable Long[] ids) {
//        return ResponseUtils.ofResult(employeeStatusAnalysisServ.delByIds(List.of(ids)));
//    }
}