package com.anplus.hr.service;

import com.alibaba.cola.dto.PageResponse;
import com.anplus.hr.domain.EmployeeInfo;
import com.anplus.hr.domain.params.ContractExpirationReminderListParam;
import com.anplus.hr.domain.params.ContractExpirationReminderParam;
import com.anplus.hr.domain.vo.ContractExpirationReminderVo;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * 员工合同续签提醒Service接口
 *
 * @author LiuBin
 * @date 2025-11-20
 */
public interface ContractExpirationReminderServ extends IService<EmployeeInfo> {


    /**
     * 分页查询员工合同续签提醒列表
     *
     * @param param        查询条件
     * @return 员工合同续签提醒分页列表
     */
    PageResponse<ContractExpirationReminderVo> queryPageList(ContractExpirationReminderListParam param);

    /**
     * 查询符合条件的员工合同续签提醒列表
     *
     * @param param 查询条件
     * @return 员工合同续签提醒列表
     */
    List<ContractExpirationReminderVo> queryList(ContractExpirationReminderListParam param);

    /**
     * 查询员工合同续签提醒
     *
     * @param id 主键
     * @return 员工合同续签提醒
     */
     ContractExpirationReminderVo queryById(Long id);

    /**
     * 新增员工合同续签提醒
     *
     * @param param 员工合同续签提醒
     * @return 是否新增成功
     */
    Boolean insertByParam(ContractExpirationReminderParam param);

    /**
     * 修改员工合同续签提醒
     *
     * @param param 员工合同续签提醒
     * @return 是否修改成功
     */
    Boolean updateByParam(ContractExpirationReminderParam param);

    /**
     * 校验并批量删除员工合同续签提醒信息
     *
     * @param ids     待删除的主键集合
     * @return 是否删除成功
     */
    Boolean delByIds(List<Long> ids);

}
