package com.anplus.hr.domain.params;

import com.anplus.hr.domain.EmployeeTraining;
import top.binfast.common.core.validate.AddGroup;
import top.binfast.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import jakarta.validation.constraints.*;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 员工培训档案业务对象 employee_training
 *
 * @author LiuBin
 * @date 2025-12-07
 */
@Data
@AutoMapper(target = EmployeeTraining.class, reverseConvertGenerate = false)
public class EmployeeTrainingParam {

    /**
     * 主键
     */
    @NotNull(message = "主键不能为空", groups = { EditGroup.class })
    private Long id;

    /**
     * 员工信息ID
     */
//    @NotNull(message = "员工信息ID不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long employeeId;

    /**
     * 姓名
     */
    @NotBlank(message = "姓名不能为空", groups = { AddGroup.class, EditGroup.class })
    private String name;

    /**
     * 身份证号
     */
    @NotBlank(message = "身份证号不能为空", groups = { AddGroup.class, EditGroup.class })
    private String idCardNumber;

    /**
     * 培训课程
     */
    @NotBlank(message = "培训课程不能为空", groups = { AddGroup.class, EditGroup.class })
    private String trainingCourse;

    /**
     * 培训机构
     */
    @NotBlank(message = "培训机构不能为空", groups = { AddGroup.class, EditGroup.class })
    private String trainingInstitution;

    /**
     * 培训讲师
     */
//    @NotBlank(message = "培训讲师不能为空", groups = { AddGroup.class, EditGroup.class })
    private String trainer;

    /**
     * 参训时间
     */
    @NotNull(message = "参训时间不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate trainingTime;

    /**
     * 服务期
     */
    @NotNull(message = "服务期不能为空", groups = { AddGroup.class, EditGroup.class })
    private LocalDate serviceEndDate;

    /**
     * 服务年限
     */
    @NotBlank(message = "服务年限不能为空", groups = { AddGroup.class, EditGroup.class })
    private String serviceYears;

    /**
     * 培训金额
     */
    @NotNull(message = "培训金额不能为空", groups = { AddGroup.class, EditGroup.class })
    private BigDecimal trainingAmount;

    /**
     * 备注
     */
//    @NotBlank(message = "备注不能为空", groups = { AddGroup.class, EditGroup.class })
    private String remark;


}
