package com.anplus.hr.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import com.alibaba.cola.dto.PageResponse;
import com.alibaba.cola.dto.Response;
import com.alibaba.cola.dto.SingleResponse;
import com.anplus.hr.domain.params.EmployeeInfoListParam;
import com.anplus.hr.domain.vo.EmployeeInfoResignImportVo;
import com.anplus.hr.domain.vo.EmployeeInfoResignVo;
import com.anplus.hr.service.EmployeeInfoResignServ;
import jakarta.annotation.Resource;
import jakarta.validation.constraints.Min;
import org.dromara.core.trans.anno.TransMethodResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import top.binfast.common.core.constant.BusinessType;
import top.binfast.common.excel.annotion.ExcelExport;
import top.binfast.common.excel.annotion.ExcelStream;
import top.binfast.common.idempotent.annotation.NoRepeatSubmit;
import top.binfast.common.log.annotation.PinSysLog;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

/**
 * @author 刘斌
 * @date 2025/11/13 20:40
 */
@Validated
@RestController
@RequestMapping("/employee/info/resign")
public class EmployeeInfoResignCtrl {

    @Resource
    private EmployeeInfoResignServ employeeInfoResignServ;

    /**
     * 查询员工信息列表
     */
    @TransMethodResult
    @SaCheckPermission("employee:infoResign:list")
    @GetMapping("/page")
    public PageResponse<EmployeeInfoResignVo> pageList(EmployeeInfoListParam param) {
        return employeeInfoResignServ.queryPageList(param);
    }

    /**
     * 导出员工信息列表
     */
    @ExcelExport
    @NoRepeatSubmit(interval = 60_000)
    @SaCheckPermission("employee:infoResign:export")
    @PinSysLog(value = "离职员工信息", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public List<EmployeeInfoResignVo> export(EmployeeInfoListParam param) {
        return employeeInfoResignServ.queryList(param);
    }

    /**
     * 导入员工信息列表
     */
//    @NoRepeatSubmit(interval = 60_000)
    @PinSysLog(value = "离职员工导入", businessType = BusinessType.IMPORT)
    @SaCheckPermission("employee:infoResign:import")
    @PostMapping(value = "/excel/import")
    public Response importWithOptions(@ExcelStream(headRowNumber = 2) Stream<EmployeeInfoResignImportVo> stream, @RequestPart("file") MultipartFile file) {
        return employeeInfoResignServ.importEmployeeResignList(stream, file);
    }

    /**
     * 获取导入模板
     */
    @ExcelExport(template = "离职模板.xlsx", fill = true)
    @PostMapping("/importTemplate")
    public List<EmployeeInfoResignImportVo> importTemplate() {
        return new ArrayList<>();
    }

    /**
     * 展示员工信息详细信息
     *
     * @param id 主键
     */
    @TransMethodResult
    @SaCheckPermission("employee:infoResign:query")
    @GetMapping("/detail/{id}")
    public SingleResponse<EmployeeInfoResignVo> infoDetail(@PathVariable @Min(1)
                                                     Long id) {
        return SingleResponse.of(employeeInfoResignServ.infoDetail(id));
    }
}
